
import gurobi

def optimize_muscle_growth():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="milligrams of vitamin B12")
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="milligrams of vitamin B9")
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="grams of fat")
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="milligrams of vitamin B5")

    # Objective function
    model.setObjective(4.44 * x0 + 1.36 * x1 + 2.79 * x2 + 9.58 * x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(5 * x2 + 16 * x3 >= 97, name="constraint_1")
    model.addConstr(7 * x0 + 16 * x3 <= 339, name="constraint_2")
    model.addConstr(7 * x0 + x1 <= 182, name="constraint_3")
    model.addConstr(7 * x0 + 5 * x2 <= 168, name="constraint_4")
    model.addConstr(x1 + 5 * x2 + 16 * x3 <= 233, name="constraint_5")
    model.addConstr(7 * x0 + x1 + 5 * x2 + 16 * x3 <= 233, name="constraint_6")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B12: {x0.varValue}")
        print(f"Milligrams of vitamin B9: {x1.varValue}")
        print(f"Grams of fat: {x2.varValue}")
        print(f"Milligrams of vitamin B5: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_muscle_growth()
