
from gurobipy import Model, GRB

# Create a new model
m = Model("Work Hours Optimization")

# Create variables
mary_hours = m.addVar(vtype=GRB.INTEGER, name="mary_hours")
paul_hours = m.addVar(vtype=GRB.INTEGER, name="paul_hours")
john_hours = m.addVar(vtype=GRB.INTEGER, name="john_hours")

# Set objective function
m.setObjective(4 * mary_hours + 7 * paul_hours + 3 * john_hours, GRB.MINIMIZE)

# Add constraints
m.addConstr(14 * mary_hours + 8 * john_hours >= 22, "computer_competence_mary_john")
m.addConstr(14 * mary_hours + 3 * paul_hours >= 16, "computer_competence_mary_paul")
m.addConstr(14 * mary_hours + 3 * paul_hours + 8 * john_hours >= 16, "computer_competence_all")

m.addConstr(9 * mary_hours + 9 * paul_hours >= 14, "organization_score_mary_paul")
m.addConstr(9 * mary_hours + 9 * john_hours >= 8, "organization_score_mary_john")
m.addConstr(9 * paul_hours + 9 * john_hours >= 21, "organization_score_paul_john")
m.addConstr(9 * mary_hours + 9 * paul_hours + 9 * john_hours >= 21, "organization_score_all")

m.addConstr(5 * mary_hours - 8 * john_hours >= 0, "additional_constraint")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Optimal objective value:', m.objVal)
    print('Mary hours:', mary_hours.x)
    print('Paul hours:', paul_hours.x)
    print('John hours:', john_hours.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status:', m.status)

