
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
M = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Mary")
P = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Paul")
J = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_John")

# Set objective function
m.setObjective(4*M + 7*P + 3*J, GRB.MINIMIZE)

# Add constraints
m.addConstr(14*M + 8*J >= 22, "computer_competence_Mary_John")
m.addConstr(14*M + 3*P >= 16, "computer_competence_Mary_Paul")
m.addConstr(14*M + 3*P + 8*J >= 16, "computer_competence_all")
m.addConstr(9*M + 9*P >= 14, "organization_score_Mary_Paul")
m.addConstr(9*M + 9*J >= 8, "organization_score_Mary_John")
m.addConstr(9*P + 9*J >= 21, "organization_score_Paul_John")
m.addConstr(9*M + 9*P + 9*J >= 21, "organization_score_all")
m.addConstr(5*M - 8*J >= 0, "additional_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Hours worked by Mary:", M.x)
    print("Hours worked by Paul:", P.x)
    print("Hours worked by John:", J.x)
else:
    print("No optimal solution found")
