
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    mary_hours = model.addVar(name="mary_hours", vtype=gurobi.GRB.INTEGER)
    paul_hours = model.addVar(name="paul_hours", vtype=gurobi.GRB.INTEGER)
    john_hours = model.addVar(name="john_hours", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(4 * mary_hours + 7 * paul_hours + 3 * john_hours, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(14 * mary_hours + 8 * john_hours >= 22, name="combined_computer_rating_mary_john")
    model.addConstr(14 * mary_hours + 3 * paul_hours >= 16, name="combined_computer_rating_mary_paul")
    model.addConstr(14 * mary_hours + 3 * paul_hours + 8 * john_hours >= 16, name="combined_computer_rating_all")

    model.addConstr(9 * mary_hours + 9 * paul_hours >= 14, name="combined_organization_score_mary_paul")
    model.addConstr(9 * mary_hours + 9 * john_hours >= 8, name="combined_organization_score_mary_john")
    model.addConstr(9 * paul_hours + 9 * john_hours >= 21, name="combined_organization_score_paul_john")
    model.addConstr(9 * mary_hours + 9 * paul_hours + 9 * john_hours >= 21, name="combined_organization_score_all")

    model.addConstr(5 * mary_hours - 8 * john_hours >= 0, name="additional_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Mary's hours: {mary_hours.varValue}")
        print(f"Paul's hours: {paul_hours.varValue}")
        print(f"John's hours: {john_hours.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
