
from gurobipy import Model, GRB

# Create a new model
model = Model("Fruit Optimization")

# Create variables
oranges = model.addVar(vtype=GRB.INTEGER, name="oranges")
kiwis = model.addVar(vtype=GRB.INTEGER, name="kiwis")
bananas = model.addVar(vtype=GRB.INTEGER, name="bananas")

# Set objective function
model.setObjective(7.89 * oranges + 1.44 * kiwis + 4.36 * bananas, GRB.MAXIMIZE)

# Add constraints
model.addConstr(6 * oranges + 6 * kiwis >= 34, "fat_constraint1")
model.addConstr(6 * kiwis + 6 * bananas >= 17, "fat_constraint2")
model.addConstr(6 * oranges + 6 * bananas >= 31, "fat_constraint3")
model.addConstr(5 * oranges - 10 * kiwis >= 0, "constraint4")
model.addConstr(6 * oranges + 6 * bananas <= 98, "fat_constraint5")
model.addConstr(6 * oranges + 6 * kiwis <= 62, "fat_constraint6")
model.addConstr(6 * kiwis + 6 * bananas <= 92, "fat_constraint7")
model.addConstr(6 * oranges + 6 * kiwis + 6 * bananas <= 49, "fat_constraint8")
model.addConstr(12 * kiwis + 8 * bananas <= 90, "cost_constraint1")
model.addConstr(9 * oranges + 12 * kiwis <= 85, "cost_constraint2")
model.addConstr(9 * oranges + 12 * kiwis + 8 * bananas <= 85, "cost_constraint3")


# Resource Constraints (given in the problem description)
model.addConstr(6 * oranges + 6 * kiwis + 6 * bananas <= 117, "total_fat") #r0
model.addConstr(9 * oranges + 12 * kiwis + 8 * bananas <= 108, "total_cost") #r1


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('oranges:', oranges.x)
    print('kiwis:', kiwis.x)
    print('bananas:', bananas.x)
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

