
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
oranges = m.addVar(name="oranges", vtype=gp.GRB.INTEGER)
kiwis = m.addVar(name="kiwis", vtype=gp.GRB.INTEGER)
bananas = m.addVar(name="bananas", vtype=gp.GRB.INTEGER)

# Objective function
m.setObjective(7.89 * oranges + 1.44 * kiwis + 4.36 * bananas, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(6 * oranges + 6 * kiwis >= 34, name="fat_oranges_kiwis")
m.addConstr(6 * kiwis + 6 * bananas >= 17, name="fat_kiwis_bananas")
m.addConstr(6 * oranges + 6 * bananas >= 31, name="fat_oranges_bananas")
m.addConstr(5 * oranges - 10 * kiwis >= 0, name="oranges_kiwis_ratio")
m.addConstr(6 * oranges + 6 * bananas <= 98, name="fat_oranges_bananas_limit")
m.addConstr(6 * oranges + 6 * kiwis <= 62, name="fat_oranges_kiwis_limit")
m.addConstr(6 * kiwis + 6 * bananas <= 92, name="fat_kiwis_bananas_limit")
m.addConstr(6 * oranges + 6 * kiwis + 6 * bananas <= 49, name="fat_total_limit")
m.addConstr(6 * oranges + 6 * kiwis + 6 * bananas <= 49, name="fat_total_limit_redundant")
m.addConstr(12 * kiwis + 8 * bananas <= 90, name="cost_kiwis_bananas")
m.addConstr(9 * oranges + 12 * kiwis <= 85, name="cost_oranges_kiwis")
m.addConstr(9 * oranges + 12 * kiwis + 8 * bananas <= 85, name="cost_total")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Oranges: {oranges.varValue}")
    print(f"Kiwis: {kiwis.varValue}")
    print(f"Bananas: {bananas.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found")
