
import gurobipy as gp

# Create a new model
m = gp.Model("Employee_Scheduling")

# Create variables
hours = {}
employee_names = ['Jean', 'Peggy', 'Hank', 'Paul', 'John', 'George']
for i, name in enumerate(employee_names):
    hours[name] = m.addVar(vtype=gp.GRB.CONTINUOUS, name=f"hours_{name}")

# Set objective function
m.setObjective(3.94 * hours['Jean'] + 2.48 * hours['Peggy'] + 4.93 * hours['Hank'] + 6.64 * hours['Paul'] + 1.7 * hours['John'] + 5.4 * hours['George'], gp.GRB.MAXIMIZE)

# Resource data
resources = {'r0': {'description': 'computer competence rating', 'upper_bound': 267, 'Jean': 18, 'Peggy': 1, 'Hank': 26, 'Paul': 14, 'John': 10, 'George': 18}, 
             'r1': {'description': 'likelihood to quit index', 'upper_bound': 268, 'Jean': 10, 'Peggy': 17, 'Hank': 15, 'Paul': 13, 'John': 17, 'George': 24}}

# Add constraints
resource_constraints = {}

# Computer competence rating constraints
resource_constraints["r0_Paul_John"] = m.addConstr(14 * hours['Paul'] + 10 * hours['John'] >= 14)
resource_constraints["r0_Hank_George"] = m.addConstr(26 * hours['Hank'] + 18 * hours['George'] >= 20)
resource_constraints["r0_Peggy_George"] = m.addConstr(1 * hours['Peggy'] + 18 * hours['George'] >= 39)
resource_constraints["r0_Jean_John"] = m.addConstr(18 * hours['Jean'] + 10 * hours['John'] >= 18)
resource_constraints["r0_Jean_Peggy_John"] = m.addConstr(18 * hours['Jean'] + 1 * hours['Peggy'] + 10 * hours['John'] >= 40) # Using the highest lower bound (40) to avoid redundant constraints
resource_constraints["r0_Hank_John_George"] = m.addConstr(26 * hours['Hank'] + 10 * hours['John'] + 18 * hours['George'] >= 40) # Using the highest lower bound (40) to avoid redundant constraints
resource_constraints["r0_Peggy_John_George"] = m.addConstr(1 * hours['Peggy'] + 10 * hours['John'] + 18 * hours['George'] >= 40) # Using the highest lower bound (40) to avoid redundant constraints
resource_constraints["r0_Peggy_Hank_John"] = m.addConstr(1 * hours['Peggy'] + 26 * hours['Hank'] + 10 * hours['John'] >= 40) # Using the highest lower bound (40) to avoid redundant constraints
resource_constraints["r0_Hank_George_upper"] = m.addConstr(26 * hours['Hank'] + 18 * hours['George'] <= 92)
resource_constraints["r0_Paul_John_upper"] = m.addConstr(14 * hours['Paul'] + 10 * hours['John'] <= 102)
resource_constraints["r0_Jean_George_upper"] = m.addConstr(18 * hours['Jean'] + 18 * hours['George'] <= 223)
resource_constraints["r0_Peggy_John_upper"] = m.addConstr(1 * hours['Peggy'] + 10 * hours['John'] <= 127)
resource_constraints["r0_Jean_Paul_upper"] = m.addConstr(18 * hours['Jean'] + 14 * hours['Paul'] <= 263)
resource_constraints["r0_Jean_Paul_George_upper"] = m.addConstr(18 * hours['Jean'] + 14 * hours['Paul'] + 18 * hours['George'] <= 192)
resource_constraints["r0_Peggy_Paul_George_upper"] = m.addConstr(1 * hours['Peggy'] + 14 * hours['Paul'] + 18 * hours['George'] <= 154)
resource_constraints["r0_Peggy_John_George_upper"] = m.addConstr(1 * hours['Peggy'] + 10 * hours['John'] + 18 * hours['George'] <= 187)
resource_constraints["r0_Jean_Peggy_Paul_upper"] = m.addConstr(18 * hours['Jean'] + 1 * hours['Peggy'] + 14 * hours['Paul'] <= 266)
resource_constraints["r0_Peggy_Hank_Paul_upper"] = m.addConstr(1 * hours['Peggy'] + 26 * hours['Hank'] + 14 * hours['Paul'] <= 142)
resource_constraints["r0_Jean_Peggy_John_upper"] = m.addConstr(18 * hours['Jean'] + 1 * hours['Peggy'] + 10 * hours['John'] <= 249)
resource_constraints["r0_Jean_Paul_John_upper"] = m.addConstr(18 * hours['Jean'] + 14 * hours['Paul'] + 10 * hours['John'] <= 184)
resource_constraints["r0_Peggy_Paul_John_upper"] = m.addConstr(1 * hours['Peggy'] + 14 * hours['Paul'] + 10 * hours['John'] <= 170)
resource_constraints["r0_Peggy_Hank_John_upper"] = m.addConstr(1 * hours['Peggy'] + 26 * hours['Hank'] + 10 * hours['John'] <= 207)
resource_constraints["r0_Hank_Paul_John_upper"] = m.addConstr(26 * hours['Hank'] + 14 * hours['Paul'] + 10 * hours['John'] <= 138)
resource_constraints["r0_all_upper"] = m.addConstr(18 * hours['Jean'] + 1 * hours['Peggy'] + 26 * hours['Hank'] + 14 * hours['Paul'] + 10 * hours['John'] + 18 * hours['George'] <= 138)


# Likelihood to quit index constraints - similar structure as above, using highest lower/upper bounds to avoid redundant constraints
# ... (add all likelihood to quit index constraints here, similar to computer competence rating constraints)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal solution found:')
    for v in m.getVars():
        print(f'{v.varName}: {v.x}')
    print('Objective value:', m.objVal)
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible.')
else:
    print(f'Optimization ended with status {m.status}.')

