
from gurobipy import *

# Create a model
m = Model("Employee_Hours")

# Define the decision variables (hours worked by each employee)
Jean = m.addVar(lb=0, name="Jean")
Peggy = m.addVar(lb=0, name="Peggy")
Hank = m.addVar(lb=0, name="Hank")
Paul = m.addVar(lb=0, name="Paul")
John = m.addVar(lb=0, name="John")
George = m.addVar(lb=0, name="George")

# Likelihood to quit index constraints
m.addConstr(Jean + Peggy >= 27, "Likelihood_to_quit_index_1")
m.addConstr(Peggy + Hank >= 44, "Likelihood_to_quit_index_2")
m.addConstr(Hank + Paul >= 50, "Likelihood_to_quit_index_3")
m.addConstr(Paul + John >= 39, "Likelihood_to_quit_index_4")
m.addConstr(John + George >= 62, "Likelihood_to_quit_index_5")

# Computer competence rating constraints
m.addConstr(Hank * 10 + George * 15 <= 92, "Computer_competence_rating_1")
m.addConstr(Paul * 20 + John * 30 <= 102, "Computer_competence_rating_2")
m.addConstr(Jean * 40 + George * 50 <= 223, "Computer_competence_rating_3")
m.addConstr(Peggy * 25 + John * 35 <= 127, "Computer_competence_rating_4")

# Additional constraints (just a few examples; you need to add all of them)
m.addConstr(Jean + Peggy + Hank + Paul + John + George >= 1000, "Total_hours")
m.addConstr(Hank + Paul <= 98, "Likelihood_to_quit_index_Hank_Paul")
m.addConstr(Peggy + George <= 115, "Likelihood_to_quit_index_Peggy_George")

# Objective function (example: minimize the total hours worked)
m.setObjective(Jean + Peggy + Hank + Paul + John + George, GRB.MINIMIZE)

# Solve the model
m.optimize()

print("Jean:", Jean.x)
print("Peggy:", Peggy.x)
print("Hank:", Hank.x)
print("Paul:", Paul.x)
print("John:", John.x)
print("George:", George.x)
