
import gurobi

def optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=0, name="hours_worked_by_Jean")
    x1 = model.addVar(lb=0, name="hours_worked_by_Peggy")
    x2 = model.addVar(lb=0, name="hours_worked_by_Hank")
    x3 = model.addVar(lb=0, name="hours_worked_by_Paul")
    x4 = model.addVar(lb=0, name="hours_worked_by_John")
    x5 = model.addVar(lb=0, name="hours_worked_by_George")

    # Objective function
    model.setObjective(3.94*x0 + 2.48*x1 + 4.93*x2 + 6.64*x3 + 1.7*x4 + 5.4*x5, gurobi.GRB.MAXIMIZE)

    # Individual constraints
    model.addConstr(x0 == 1, name='jean_hours')
    model.addConstr(x1 == 1, name='peggy_hours')
    model.addConstr(x2 == 1, name='hank_hours')
    model.addConstr(x3 == 1, name='paul_hours')
    model.addConstr(x4 == 1, name='john_hours')
    model.addConstr(x5 == 1, name='george_hours')

    model.addConstr(18*x0 + 1*x1 + 26*x2 + 14*x3 + 10*x4 + 18*x5 <= 267)
    model.addConstr(10*x0 + 17*x1 + 15*x2 + 13*x3 + 17*x4 + 24*x5 <= 268)

    # Computer competence rating constraints
    model.addConstr(18*x0 + x1 + 26*x2 + 14*x3 + 10*x4 + 18*x5 <= 267)
    model.addConstr(18*x0 <= 18)
    model.addConstr(x1 <= 1)
    model.addConstr(26*x2 <= 26)
    model.addConstr(14*x3 <= 14)
    model.addConstr(10*x4 <= 10)
    model.addConstr(18*x5 <= 18)

    model.addConstr(14*x3 + 10*x4 >= 14)
    model.addConstr(26*x2 + 18*x5 >= 20)
    model.addConstr(x1 + 18*x5 >= 39)
    model.addConstr(18*x0 + 10*x4 >= 18)
    model.addConstr(18*x0 + x1 + 10*x4 >= 32)

    # Likelihood to quit index constraints
    model.addConstr(10*x0 + 13*x3 >= 29)
    model.addConstr(15*x2 + 17*x4 >= 38)
    model.addConstr(10*x0 + 17*x4 >= 17)
    model.addConstr(17*x1 + 15*x2 >= 16)
    model.addConstr(15*x2 + 13*x3 >= 22)
    model.addConstr(13*x3 + 24*x5 >= 44)

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
    else:
        print("No solution found")

optimization_problem()
