
import gurobipy as gp

# Create a new model
m = gp.Model("Work_Hour_Optimization")

# Create variables
dale_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Dale_Hours")
ringo_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Ringo_Hours")
peggy_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Peggy_Hours")
hank_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Hank_Hours")

# Set objective function
m.setObjective(5 * dale_hours + 3 * ringo_hours + 4 * peggy_hours + 8 * hank_hours, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(19 * peggy_hours + 11 * hank_hours >= 24, "c1")
m.addConstr(20 * dale_hours + 23 * ringo_hours >= 22, "c2")
m.addConstr(5 * dale_hours - 2 * peggy_hours >= 0, "c3")
m.addConstr(21 * dale_hours + 13 * peggy_hours <= 97, "c4")
m.addConstr(21 * dale_hours + 29 * hank_hours <= 101, "c5")
m.addConstr(9 * ringo_hours + 13 * peggy_hours <= 126, "c6")
m.addConstr(21 * dale_hours + 9 * ringo_hours <= 179, "c7")
m.addConstr(9 * ringo_hours + 29 * hank_hours <= 106, "c8")
m.addConstr(21 * dale_hours + 9 * ringo_hours + 13 * peggy_hours + 29 * hank_hours <= 106, "c9")
m.addConstr(20 * dale_hours + 19 * peggy_hours <= 101, "c10")
m.addConstr(23 * ringo_hours + 11 * hank_hours <= 98, "c11")
m.addConstr(20 * dale_hours + 11 * hank_hours <= 111, "c12")
m.addConstr(20 * dale_hours + 23 * ringo_hours <= 219, "c13")
m.addConstr(20 * dale_hours + 23 * ringo_hours + 11 * hank_hours <= 126, "c14")
m.addConstr(20 * dale_hours + 23 * ringo_hours + 19 * peggy_hours <= 123, "c15")
m.addConstr(20 * dale_hours + 19 * peggy_hours + 11 * hank_hours <= 109, "c16")
m.addConstr(20 * dale_hours + 23 * ringo_hours + 19 * peggy_hours + 11 * hank_hours <= 109, "c17")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

