
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    D = model.addVar(lb=0, name="hours_worked_by_Dale")
    R = model.addVar(lb=0, name="hours_worked_by_Ringo")
    P = model.addVar(lb=0, name="hours_worked_by_Peggy")
    H = model.addVar(lb=0, name="hours_worked_by_Hank")

    # Define the objective function
    model.setObjective(5*D + 3*R + 4*P + 8*H, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(19*P + 11*H >= 24)
    model.addConstr(20*D + 23*R >= 22)
    model.addConstr(5*D - 2*P >= 0)
    model.addConstr(21*D + 13*P <= 97)
    model.addConstr(21*D + 29*H <= 101)
    model.addConstr(9*R + 13*P <= 126)
    model.addConstr(21*D + 9*R <= 179)
    model.addConstr(9*R + 29*H <= 106)
    model.addConstr(21*D + 9*R + 13*P + 29*H <= 106)
    model.addConstr(20*D + 19*P <= 101)
    model.addConstr(23*R + 11*H <= 98)
    model.addConstr(20*D + 11*H <= 111)
    model.addConstr(20*D + 23*R <= 219)
    model.addConstr(20*D + 23*R + 11*H <= 126)
    model.addConstr(20*D + 23*R + 19*P <= 123)
    model.addConstr(20*D + 19*P + 11*H <= 109)
    model.addConstr(20*D + 23*R + 19*P + 11*H <= 109)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Dale: {D.varValue}")
        print(f"Hours worked by Ringo: {R.varValue}")
        print(f"Hours worked by Peggy: {P.varValue}")
        print(f"Hours worked by Hank: {H.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
