
from gurobipy import *

# Create a new model
m = Model("Food_Optimization")

# Define the variables
ravioli = m.addVar(lb=0, name="ravioli", vtype=GRB.CONTINUOUS)
knishes = m.addVar(lb=0, name="knishes", vtype=GRB.CONTINUOUS)
chicken_drumsticks = m.addVar(lb=0, name="chicken_drumsticks", vtype=GRB.CONTINUOUS)

# Objective function
m.setObjective(6.2 * ravioli + 1.9 * knishes + 6.3 * chicken_drumsticks, GRB.MINIMIZE)

# Constraints
m.addConstr(0.37 * ravioli + 0.97 * chicken_drumsticks >= 10, name="tastiness_ravioli_chicken_min")
m.addConstr(0.37 * ravioli + 0.83 * knishes >= 3, name="tastiness_ravioli_knishes_min")
m.addConstr(0.37 * ravioli + 0.83 * knishes + 0.97 * chicken_drumsticks >= 3, name="tastiness_all_min")
m.addConstr(1.18 * knishes + 0.14 * chicken_drumsticks >= 14, name="protein_knishes_chicken_min")
m.addConstr(0.39 * ravioli + 0.14 * chicken_drumsticks >= 9, name="protein_ravioli_chicken_min")
m.addConstr(0.39 * ravioli + 1.18 * knishes >= 8, name="protein_ravioli_knishes_min")
m.addConstr(0.39 * ravioli + 1.18 * knishes + 0.14 * chicken_drumsticks >= 9, name="protein_all_min")
m.addConstr(-2 * ravioli + 6 * knishes >= 0, name="ravioli_knishes_linear_constraint")
m.addConstr(0.37 * ravioli + 0.83 * knishes <= 21, name="tastiness_ravioli_knishes_max")
m.addConstr(0.39 * ravioli + 0.14 * chicken_drumsticks <= 51, name="protein_ravioli_chicken_max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"ravioli: {ravioli.x}")
    print(f"knishes: {knishes.x}")
    print(f"chicken_drumsticks: {chicken_drumsticks.x}")
else:
    print("No optimal solution found.")
