
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    ravioli = model.addVar(lb=0, name="ravioli", vtype=gurobi.GRB.CONTINUOUS)
    knishes = model.addVar(lb=0, name="knishes", vtype=gurobi.GRB.CONTINUOUS)
    chicken_drumsticks = model.addVar(lb=0, name="chicken_drumsticks", vtype=gurobi.GRB.CONTINUOUS)

    # Objective function
    model.setObjective(6.2 * ravioli + 1.9 * knishes + 6.3 * chicken_drumsticks, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(0.37 * ravioli + 0.97 * chicken_drumsticks >= 10, name="tastiness_ravioli_chicken")
    model.addConstr(0.37 * ravioli + 0.83 * knishes >= 3, name="tastiness_ravioli_knishes")
    model.addConstr(0.37 * ravioli + 0.83 * knishes + 0.97 * chicken_drumsticks >= 3, name="tastiness_all")
    model.addConstr(1.18 * knishes + 0.14 * chicken_drumsticks >= 14, name="protein_knishes_chicken")
    model.addConstr(0.39 * ravioli + 0.14 * chicken_drumsticks >= 9, name="protein_ravioli_chicken")
    model.addConstr(0.39 * ravioli + 1.18 * knishes >= 8, name="protein_ravioli_knishes")
    model.addConstr(0.39 * ravioli + 1.18 * knishes + 0.14 * chicken_drumsticks >= 9, name="protein_all")
    model.addConstr(-2 * ravioli + 6 * knishes >= 0, name="knishes_vs_ravioli")
    model.addConstr(0.37 * ravioli + 0.83 * knishes <= 21, name="tastiness_ravioli_knishes_max")
    model.addConstr(0.39 * ravioli + 0.14 * chicken_drumsticks <= 51, name="protein_ravioli_chicken_max")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Ravioli: {ravioli.x}")
        print(f"Knishes: {knishes.x}")
        print(f"Chicken Drumsticks: {chicken_drumsticks.x}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("No feasible solution exists.")
    else:
        print("Optimization failed.")

solve_optimization_problem()
