
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
iron = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="iron")
fiber = m.addVar(lb=0, vtype=GRB.INTEGER, name="fiber")
vitamin_a = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_a")

# Set objective function
m.setObjective(iron**2 + 3*iron*fiber + 4*iron*vitamin_a + 9*fiber*vitamin_a + 7*vitamin_a**2 + 3*fiber, GRB.MAXIMIZE)

# Add constraints
m.addConstr(27*iron + 1*vitamin_a >= 58, "c1")
m.addConstr(27*iron + 14*fiber + 1*vitamin_a >= 62, "c2")
m.addConstr(27*iron**2 + 1*vitamin_a**2 <= 177, "c3") # Note: This constraint involves squared variables. Gurobi handles this as a quadratic constraint.
m.addConstr(27*iron + 14*fiber + 1*vitamin_a <= 234, "c4") # Using the upper bound provided in the resources.


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal solution found:")
    print(f"  Iron: {iron.x}")
    print(f"  Fiber: {fiber.x}")
    print(f"  Vitamin A: {vitamin_a.x}")
    print(f"  Objective value: {m.objVal}")

