
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Create variables
x0 = m.addVar(lb=0, name="milligrams_of_iron")  # Amount of milligrams of iron
x1 = m.addVar(vtype=GRB.INTEGER, lb=0, name="grams_of_fiber")  # Grams of fiber, integer
x2 = m.addVar(lb=0, name="milligrams_of_vitamin_A")  # Milligrams of vitamin A

# Objective function: Maximize
m.setObjective(x0**2 + 3*x0*x1 + 4*x0*x2 + 9*x1*x2 + 7*x2**2 + 3*x1, GRB.MAXIMIZE)

# Constraints
m.addConstr(27*x0 + x2 >= 58, name="min_combined_index_iron_vitaminA")
m.addConstr(27*x0 + 14*x1 + x2 >= 62, name="min_total_combined_index")
m.addConstr(x0**2 + x2**2 <= 177, name="max_from_squares_iron_vitaminA")
m.addConstr(27*x0 + 14*x1 + x2 <= 177, name="max_total_combined_index")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"milligrams_of_iron: {x0.x}")
    print(f"grams_of_fiber: {x1.x}")
    print(f"milligrams_of_vitamin_A: {x2.x}")
else:
    print("No optimal solution found.")
