
import gurobi as gp

# Define the model
model = gp.Model("optimization_problem")

# Define the variables
milligrams_of_iron = model.addVar(name="milligrams_of_iron", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
grams_of_fiber = model.addVar(name="grams_of_fiber", lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.INTEGER)
milligrams_of_vitamin_A = model.addVar(name="milligrams_of_vitamin_A", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)

# Objective function
model.setObjective(1 * milligrams_of_iron**2 + 3 * milligrams_of_iron * grams_of_fiber + 
                   4 * milligrams_of_iron * milligrams_of_vitamin_A + 9 * grams_of_fiber * milligrams_of_vitamin_A + 
                   7 * milligrams_of_vitamin_A**2 + 3 * grams_of_fiber, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(27 * milligrams_of_iron <= 234, name="cognitive_performance_index_iron")
model.addConstr(14 * grams_of_fiber <= 234, name="cognitive_performance_index_fiber")
model.addConstr(1 * milligrams_of_vitamin_A <= 234, name="cognitive_performance_index_vitamin_A")

model.addConstr(27 * milligrams_of_iron + 1 * milligrams_of_vitamin_A >= 58, name="combined_cognitive_performance_index_iron_vitamin_A")
model.addConstr(27 * milligrams_of_iron + 14 * grams_of_fiber + 1 * milligrams_of_vitamin_A >= 62, name="combined_cognitive_performance_index_all")

model.addConstr(27**2 * milligrams_of_iron**2 + 1**2 * milligrams_of_vitamin_A**2 <= 177, name="combined_cognitive_performance_index_iron_vitamin_A_squared")

# Note: The constraint for the total combined cognitive performance index from 
# milligrams of iron, grams of fiber, and milligrams of vitamin A has to be no more than 177
# might need a different formulation as it seems to involve a non-linear term not directly 
# supported in Gurobi without additional variables or transformations.

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Milligrams of Iron: {milligrams_of_iron.varValue}")
    print(f"Grams of Fiber: {grams_of_fiber.varValue}")
    print(f"Milligrams of Vitamin A: {milligrams_of_vitamin_A.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
