
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
ham_sandwiches = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="ham_sandwiches")
peanutbutter_sandwiches = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="peanutbutter_sandwiches")
fruit_salads = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="fruit_salads")
bowls_of_cereal = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bowls_of_cereal")

# Set objective function
model.setObjective(3 * ham_sandwiches + 4 * peanutbutter_sandwiches + 9 * fruit_salads + 3 * bowls_of_cereal, GRB.MAXIMIZE)

# Add constraints
model.addConstr(6 * ham_sandwiches + 5 * fruit_salads >= 18, "iron_constraint1")
model.addConstr(6 * ham_sandwiches + 6 * bowls_of_cereal >= 31, "iron_constraint2")
model.addConstr(1 * peanutbutter_sandwiches + 3 * fruit_salads >= 24, "fiber_constraint1")
model.addConstr(1 * peanutbutter_sandwiches + 3 * fruit_salads + 1 * bowls_of_cereal >= 23, "fiber_constraint2")
model.addConstr(3 * ham_sandwiches + 1 * peanutbutter_sandwiches + 3 * fruit_salads >= 23, "fiber_constraint3")
model.addConstr(1 * peanutbutter_sandwiches + 3 * fruit_salads + 1 * bowls_of_cereal >= 13, "fiber_constraint4")
model.addConstr(3 * ham_sandwiches + 1 * peanutbutter_sandwiches + 3 * fruit_salads >= 13, "fiber_constraint5")
model.addConstr(4 * ham_sandwiches + 7 * fruit_salads >= 8, "tastiness_constraint1")
model.addConstr(6 * ham_sandwiches + 6 * bowls_of_cereal <= 78, "iron_constraint3")
model.addConstr(6 * ham_sandwiches + 8 * peanutbutter_sandwiches + 5 * fruit_salads <= 66, "iron_constraint4")
model.addConstr(6 * ham_sandwiches + 8 * peanutbutter_sandwiches + 6 * bowls_of_cereal <= 118, "iron_constraint5")
model.addConstr(6 * ham_sandwiches + 8 * peanutbutter_sandwiches + 5 * fruit_salads + 6 * bowls_of_cereal <= 118, "iron_constraint6")
model.addConstr(8 * ham_sandwiches + 6 * fruit_salads <= 47, "cost_constraint1")
model.addConstr(8 * ham_sandwiches + 1 * peanutbutter_sandwiches + 6 * fruit_salads + 4 * bowls_of_cereal <= 47, "cost_constraint2")
model.addConstr(3 * ham_sandwiches + 1 * peanutbutter_sandwiches <= 61, "fiber_constraint6")
model.addConstr(1 * peanutbutter_sandwiches + 1 * bowls_of_cereal <= 42, "fiber_constraint7")
model.addConstr(3 * ham_sandwiches + 3 * fruit_salads <= 34, "fiber_constraint8")
model.addConstr(3 * ham_sandwiches + 3 * fruit_salads + 1 * bowls_of_cereal <= 93, "fiber_constraint9")
model.addConstr(3 * ham_sandwiches + 1 * peanutbutter_sandwiches + 1 * bowls_of_cereal <= 39, "fiber_constraint10")
model.addConstr(3 * ham_sandwiches + 1 * peanutbutter_sandwiches + 3 * fruit_salads <= 72, "fiber_constraint11")
model.addConstr(1 * peanutbutter_sandwiches + 3 * fruit_salads + 1 * bowls_of_cereal <= 75, "fiber_constraint12")
model.addConstr(3 * ham_sandwiches + 1 * peanutbutter_sandwiches + 3 * fruit_salads + 1 * bowls_of_cereal <= 75, "fiber_constraint13")
model.addConstr(4 * ham_sandwiches + 8 * bowls_of_cereal <= 50, "tastiness_constraint2")
model.addConstr(4 * ham_sandwiches + 7 * fruit_salads <= 32, "tastiness_constraint3")
model.addConstr(4 * ham_sandwiches + 8 * peanutbutter_sandwiches <= 52, "tastiness_constraint4")
model.addConstr(8 * peanutbutter_sandwiches + 8 * bowls_of_cereal <= 23, "tastiness_constraint5")
model.addConstr(4 * ham_sandwiches + 8 * peanutbutter_sandwiches + 8 * bowls_of_cereal <= 53, "tastiness_constraint6")
model.addConstr(8 * peanutbutter_sandwiches + 7 * fruit_salads + 8 * bowls_of_cereal <= 35, "tastiness_constraint7")
model.addConstr(4 * ham_sandwiches + 8 * peanutbutter_sandwiches + 7 * fruit_salads + 8 * bowls_of_cereal <= 35, "tastiness_constraint8")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Ham sandwiches:", ham_sandwiches.x)
    print("Peanutbutter sandwiches:", peanutbutter_sandwiches.x)
    print("Fruit salads:", fruit_salads.x)
    print("Bowls of cereal:", bowls_of_cereal.x)
    print("Objective value:", model.objVal)
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print("Optimization terminated with status:", model.status)

