
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
ham_sandwiches = m.addVar(name="ham_sandwiches", lb=0)
peanutbutter_sandwiches = m.addVar(name="peanutbutter_sandwiches", lb=0)
fruit_salads = m.addVar(name="fruit_salads", lb=0)
bowls_of_cereal = m.addVar(name="bowls_of_cereal", lb=0)

# Define the objective function
m.setObjective(3 * ham_sandwiches + 4 * peanutbutter_sandwiches + 9 * fruit_salads + 3 * bowls_of_cereal, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(6 * ham_sandwiches + 5 * fruit_salads >= 18)
m.addConstr(6 * ham_sandwiches + 6 * bowls_of_cereal >= 31)
m.addConstr(1 * peanutbutter_sandwiches + 3 * fruit_salads >= 24)
m.addConstr(1 * peanutbutter_sandwiches + 3 * fruit_salads + 1 * bowls_of_cereal >= 23)
m.addConstr(3 * ham_sandwiches + 1 * peanutbutter_sandwiches + 3 * fruit_salads >= 23)
m.addConstr(1 * peanutbutter_sandwiches + 3 * fruit_salads + 1 * bowls_of_cereal >= 13)
m.addConstr(3 * ham_sandwiches + 1 * peanutbutter_sandwiches + 3 * fruit_salads >= 13)
m.addConstr(4 * ham_sandwiches + 7 * fruit_salads >= 8)
m.addConstr(6 * ham_sandwiches + 6 * bowls_of_cereal <= 78)
m.addConstr(6 * ham_sandwiches + 8 * peanutbutter_sandwiches + 5 * fruit_salads <= 66)
m.addConstr(6 * ham_sandwiches + 8 * peanutbutter_sandwiches + 6 * bowls_of_cereal <= 118)
m.addConstr(6 * ham_sandwiches + 8 * peanutbutter_sandwiches + 5 * fruit_salads + 6 * bowls_of_cereal <= 118)
m.addConstr(8 * ham_sandwiches + 6 * fruit_salads <= 47)
m.addConstr(8 * ham_sandwiches + 1 * peanutbutter_sandwiches + 6 * fruit_salads + 4 * bowls_of_cereal <= 47)
m.addConstr(3 * ham_sandwiches + 1 * peanutbutter_sandwiches <= 61)
m.addConstr(1 * peanutbutter_sandwiches + 1 * bowls_of_cereal <= 42)
m.addConstr(3 * ham_sandwiches + 3 * fruit_salads <= 34)
m.addConstr(3 * ham_sandwiches + 1 * peanutbutter_sandwiches + 3 * fruit_salads + 1 * bowls_of_cereal <= 93)
m.addConstr(3 * ham_sandwiches + 1 * peanutbutter_sandwiches + 1 * bowls_of_cereal <= 39)
m.addConstr(3 * ham_sandwiches + 1 * peanutbutter_sandwiches + 3 * fruit_salads <= 72)
m.addConstr(1 * peanutbutter_sandwiches + 3 * fruit_salads + 1 * bowls_of_cereal <= 75)
m.addConstr(3 * ham_sandwiches + 1 * peanutbutter_sandwiches + 3 * fruit_salads + 1 * bowls_of_cereal <= 75)
m.addConstr(4 * ham_sandwiches + 8 * bowls_of_cereal <= 50)
m.addConstr(4 * ham_sandwiches + 7 * fruit_salads <= 32)
m.addConstr(4 * ham_sandwiches + 8 * peanutbutter_sandwiches <= 52)
m.addConstr(8 * peanutbutter_sandwiches + 8 * bowls_of_cereal <= 23)
m.addConstr(4 * ham_sandwiches + 8 * peanutbutter_sandwiches + 8 * bowls_of_cereal <= 53)
m.addConstr(8 * peanutbutter_sandwiches + 7 * fruit_salads + 8 * bowls_of_cereal <= 35)
m.addConstr(4 * ham_sandwiches + 8 * peanutbutter_sandwiches + 7 * fruit_salads + 8 * bowls_of_cereal <= 35)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Ham sandwiches: ", ham_sandwiches.varValue)
    print("Peanutbutter sandwiches: ", peanutbutter_sandwiches.varValue)
    print("Fruit salads: ", fruit_salads.varValue)
    print("Bowls of cereal: ", bowls_of_cereal.varValue)
else:
    print("The model is infeasible")
