
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
ibuprofen = model.addVar(vtype=GRB.INTEGER, name="ibuprofen")
toilet_paper = model.addVar(vtype=GRB.INTEGER, name="toilet_paper")
cookies = model.addVar(vtype=GRB.INTEGER, name="cookies")
lightbulbs = model.addVar(vtype=GRB.INTEGER, name="lightbulbs")

# Set objective function
model.setObjective(8 * ibuprofen + 2 * toilet_paper + 9 * cookies + 1 * lightbulbs, GRB.MINIMIZE)

# Add constraints
model.addConstr(8 * ibuprofen + 7 * cookies >= 36, "c1")
model.addConstr(8 * ibuprofen + 7 * lightbulbs >= 47, "c2")
model.addConstr(8 * ibuprofen + 14 * toilet_paper + 7 * lightbulbs >= 29, "c3")
model.addConstr(14 * toilet_paper + 7 * cookies + 7 * lightbulbs >= 29, "c4")
model.addConstr(8 * ibuprofen + 14 * toilet_paper + 7 * lightbulbs >= 35, "c5")
model.addConstr(14 * toilet_paper + 7 * cookies + 7 * lightbulbs >= 35, "c6")
model.addConstr(8 * ibuprofen + 14 * toilet_paper + 7 * cookies + 7 * lightbulbs >= 35, "c7")
model.addConstr(8 * cookies + 6 * lightbulbs >= 43, "c8")
model.addConstr(10 * ibuprofen + 8 * cookies >= 31, "c9")
model.addConstr(10 * ibuprofen + 13 * toilet_paper >= 19, "c10")
model.addConstr(13 * toilet_paper + 8 * cookies + 6 * lightbulbs >= 38, "c11")
model.addConstr(10 * ibuprofen + 13 * toilet_paper + 6 * lightbulbs >= 38, "c12")
model.addConstr(13 * toilet_paper + 8 * cookies + 6 * lightbulbs >= 29, "c13")
model.addConstr(10 * ibuprofen + 13 * toilet_paper + 6 * lightbulbs >= 29, "c14")
model.addConstr(10 * ibuprofen + 13 * toilet_paper + 8 * cookies + 6 * lightbulbs >= 29, "c15")
model.addConstr(5 * toilet_paper - 2 * lightbulbs >= 0, "c16")
model.addConstr(8 * cookies + 6 * lightbulbs <= 74, "c17")
model.addConstr(10 * ibuprofen + 13 * toilet_paper + 6 * lightbulbs <= 77, "c18")
model.addConstr(10 * ibuprofen + 8 * cookies + 6 * lightbulbs <= 96, "c19")


# Resource constraints (from the provided context)
model.addConstr(8 * ibuprofen + 14 * toilet_paper + 7 * cookies + 7 * lightbulbs <= 208, "r0")
model.addConstr(10 * ibuprofen + 13 * toilet_paper + 8 * cookies + 6 * lightbulbs <= 182, "r1")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

