
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="bottles_of_ibuprofen", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="toilet_paper_rolls", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="cookies", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="lightbulbs", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(8*x0 + 2*x1 + 9*x2 + x3, gurobi.GRB.MINIMIZE)

    # Individual item constraints
    model.addConstr(8*x0 <= 208)
    model.addConstr(14*x1 <= 208)
    model.addConstr(7*x2 <= 208)
    model.addConstr(7*x3 <= 208)
    model.addConstr(10*x0 <= 182)
    model.addConstr(13*x1 <= 182)
    model.addConstr(8*x2 <= 182)
    model.addConstr(6*x3 <= 182)

    # Combined usefulness rating constraints
    model.addConstr(8*x0 + 7*x2 >= 36)
    model.addConstr(8*x0 + 7*x3 >= 47)
    model.addConstr(8*x0 + 14*x1 + 7*x3 >= 29)
    model.addConstr(14*x1 + 7*x2 + 7*x3 >= 29)
    model.addConstr(8*x0 + 14*x1 + 7*x3 >= 35)
    model.addConstr(14*x1 + 7*x2 + 7*x3 >= 35)
    model.addConstr(8*x0 + 14*x1 + 7*x2 + 7*x3 >= 35)

    # Combined storage space constraints
    model.addConstr(8*x2 + 6*x3 >= 43)
    model.addConstr(10*x0 + 8*x2 >= 31)
    model.addConstr(10*x0 + 13*x1 >= 19)
    model.addConstr(13*x1 + 8*x2 + 6*x3 >= 38)
    model.addConstr(10*x0 + 13*x1 + 6*x3 >= 38)
    model.addConstr(13*x1 + 8*x2 + 6*x3 >= 29)
    model.addConstr(10*x0 + 13*x1 + 6*x3 >= 29)
    model.addConstr(10*x0 + 13*x1 + 8*x2 + 6*x3 >= 29)

    # Linear constraint
    model.addConstr(5*x1 - 2*x3 >= 0)

    # Bounds for storage
    model.addConstr(8*x2 + 6*x3 <= 74)
    model.addConstr(10*x0 + 13*x1 + 6*x3 <= 77)
    model.addConstr(10*x0 + 8*x2 + 6*x3 <= 96)

    # Non-negativity constraints
    model.addConstr(x0 >= 0)
    model.addConstr(x1 >= 0)
    model.addConstr(x2 >= 0)
    model.addConstr(x3 >= 0)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("bottles_of_ibuprofen: ", x0.varValue)
        print("toilet_paper_rolls: ", x1.varValue)
        print("cookies: ", x2.varValue)
        print("lightbulbs: ", x3.varValue)
    else:
        print("No solution found")

optimize_problem()
