
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_b12 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b12")
magnesium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="magnesium")
vitamin_e = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_e")
vitamin_b5 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b5")

# Set objective function
m.setObjective(2 * vitamin_b12 + 6 * magnesium + 4 * vitamin_e + 4 * vitamin_b5, gp.GRB.MAXIMIZE)

# Add constraints based on resource indices
resources = {
    'r0': {'upper_bound': 110, 'x0': 6, 'x1': 3, 'x2': 8, 'x3': 1},  # energy stability
    'r1': {'upper_bound': 110, 'x0': 1, 'x1': 8, 'x2': 3, 'x3': 6},  # cardiovascular support
    'r2': {'upper_bound': 88, 'x0': 8, 'x1': 4, 'x2': 8, 'x3': 9},  # immune support
    'r3': {'upper_bound': 103, 'x0': 4, 'x1': 5, 'x2': 10, 'x3': 4}  # cognitive performance
}

for r_name, r_data in resources.items():
    m.addConstr(r_data['x0'] * vitamin_b12 + r_data['x1'] * magnesium + r_data['x2'] * vitamin_e + r_data['x3'] * vitamin_b5 <= r_data['upper_bound'], name=r_name)


# Add additional constraints
m.addConstr(3 * magnesium + 8 * vitamin_e + 1 * vitamin_b5 >= 25, "c1")
m.addConstr(3 * vitamin_e + 6 * vitamin_b5 >= 10, "c2")
m.addConstr(4 * vitamin_b12 + 5 * magnesium >= 11, "c3")
m.addConstr(4 * vitamin_b12 + 10 * vitamin_e >= 22, "c4")
m.addConstr(10 * vitamin_e + 4 * vitamin_b5 >= 25, "c5")
m.addConstr(4 * vitamin_b12 + 4 * vitamin_b5 >= 9, "c6")
m.addConstr(4 * vitamin_b12 + 10 * vitamin_e + 4 * vitamin_b5 >= 22, "c7")
m.addConstr(2 * vitamin_b12 - 6 * vitamin_e >= 0, "c8")
m.addConstr(3 * magnesium + 8 * vitamin_e <= 104, "c9")
m.addConstr(3 * magnesium + 8 * vitamin_e + 1 * vitamin_b5 <= 107, "c10")
m.addConstr(6 * vitamin_b12 + 8 * vitamin_e + 1 * vitamin_b5 <= 50, "c11")
m.addConstr(6 * vitamin_b12 + 3 * magnesium + 1 * vitamin_b5 <= 104, "c12")
m.addConstr(6 * vitamin_b12 + 3 * magnesium + 8 * vitamin_e <= 71, "c13")
m.addConstr(6 * vitamin_b12 + 3 * magnesium + 8 * vitamin_e + 1 * vitamin_b5 <= 71, "c14")
m.addConstr(1 * vitamin_b12 + 8 * magnesium <= 104, "c15")
m.addConstr(1 * vitamin_b12 + 6 * vitamin_b5 <= 80, "c16")
m.addConstr(8 * magnesium + 6 * vitamin_b5 <= 35, "c17")
m.addConstr(1 * vitamin_b12 + 3 * vitamin_e <= 86, "c18")
m.addConstr(8 * magnesium + 3 * vitamin_e <= 57, "c19")
m.addConstr(1 * vitamin_b12 + 8 * magnesium + 6 * vitamin_b5 <= 51, "c20")
m.addConstr(1 * vitamin_b12 + 8 * magnesium + 3 * vitamin_e + 6 * vitamin_b5 <= 51, "c21")
m.addConstr(8 * vitamin_b12 + 9 * vitamin_b5 <= 69, "c22")
m.addConstr(4 * magnesium + 8 * vitamin_e <= 67, "c23")
m.addConstr(8 * vitamin_e + 9 * vitamin_b5 <= 35, "c24")
m.addConstr(8 * vitamin_b12 + 4 * magnesium <= 60, "c25")
m.addConstr(8 * vitamin_b12 + 4 * magnesium + 8 * vitamin_e <= 82, "c26")
m.addConstr(8 * vitamin_b12 + 4 * magnesium + 8 * vitamin_e + 9 * vitamin_b5 <= 82, "c27")
m.addConstr(4 * vitamin_b12 + 4 * vitamin_b5 <= 39, "c28")
m.addConstr(4 * vitamin_b12 + 5 * magnesium + 10 * vitamin_e + 4 * vitamin_b5 <= 39, "c29")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

