
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="milligrams of vitamin B12", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x1 = m.addVar(name="milligrams of magnesium", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x2 = m.addVar(name="milligrams of vitamin E", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x3 = m.addVar(name="milligrams of vitamin B5", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)

# Define the objective function
m.setObjective(2*x0 + 6*x1 + 4*x2 + 4*x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(6*x0 <= 110)
m.addConstr(1*x0 <= 110)
m.addConstr(8*x0 <= 88)
m.addConstr(4*x0 <= 103)
m.addConstr(3*x1 <= 110)
m.addConstr(8*x1 <= 110)
m.addConstr(4*x1 <= 88)
m.addConstr(5*x1 <= 103)
m.addConstr(8*x2 <= 110)
m.addConstr(3*x2 <= 110)
m.addConstr(8*x2 <= 88)
m.addConstr(10*x2 <= 103)
m.addConstr(1*x3 <= 110)
m.addConstr(6*x3 <= 110)
m.addConstr(9*x3 <= 88)
m.addConstr(4*x3 <= 103)
m.addConstr(3*x1 + 8*x2 + 1*x3 >= 25)
m.addConstr(3*x2 + 6*x3 >= 10)
m.addConstr(4*x0 + 5*x1 >= 11)
m.addConstr(4*x0 + 10*x2 >= 22)
m.addConstr(10*x2 + 4*x3 >= 25)
m.addConstr(4*x0 + 4*x3 >= 9)
m.addConstr(4*x0 + 10*x2 + 4*x3 >= 22)
m.addConstr(2*x0 - 6*x2 >= 0)
m.addConstr(3*x1 + 8*x2 <= 104)
m.addConstr(3*x1 + 8*x2 + 1*x3 <= 107)
m.addConstr(6*x0 + 8*x2 + 1*x3 <= 50)
m.addConstr(6*x0 + 3*x1 + 1*x3 <= 104)
m.addConstr(6*x0 + 3*x1 + 8*x2 <= 71)
m.addConstr(6*x0 + 3*x1 + 8*x2 + 1*x3 <= 71)
m.addConstr(1*x0 + 8*x1 <= 104)
m.addConstr(1*x0 + 6*x3 <= 80)
m.addConstr(8*x1 + 6*x3 <= 35)
m.addConstr(1*x0 + 3*x2 <= 86)
m.addConstr(8*x1 + 3*x2 <= 57)
m.addConstr(1*x0 + 8*x1 + 6*x3 <= 51)
m.addConstr(1*x0 + 8*x1 + 3*x2 + 6*x3 <= 51)
m.addConstr(8*x0 + 9*x3 <= 69)
m.addConstr(4*x1 + 8*x2 <= 67)
m.addConstr(8*x2 + 9*x3 <= 35)
m.addConstr(8*x0 + 4*x1 <= 60)
m.addConstr(8*x0 + 4*x1 + 8*x2 <= 82)
m.addConstr(8*x0 + 4*x1 + 8*x2 + 9*x3 <= 82)
m.addConstr(4*x0 + 4*x3 <= 39)
m.addConstr(4*x0 + 5*x1 + 10*x2 + 4*x3 <= 39)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Milligrams of vitamin B12: ", x0.varValue)
    print("Milligrams of magnesium: ", x1.varValue)
    print("Milligrams of vitamin E: ", x2.varValue)
    print("Milligrams of vitamin B5: ", x3.varValue)
    print("Objective function value: ", m.objVal)
else:
    print("No optimal solution found.")
