
from gurobipy import Model, GRB

# Create a new model
model = Model("optimize_work_hours")

# Create variables
peggy_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="peggy_hours")
bobby_hours = model.addVar(lb=0, vtype=GRB.INTEGER, name="bobby_hours")

# Set objective function
model.setObjective(2 * peggy_hours + 7 * bobby_hours, GRB.MAXIMIZE)

# Add constraints
model.addConstr(4 * peggy_hours + 14 * bobby_hours >= 65, "organization_score_min")
model.addConstr(15 * peggy_hours + 24 * bobby_hours >= 22, "work_quality_min")
model.addConstr(19 * peggy_hours + 2 * bobby_hours >= 72, "paperwork_min")
model.addConstr(-4 * peggy_hours + 6 * bobby_hours >= 0, "hours_relation")
model.addConstr(4 * peggy_hours + 14 * bobby_hours <= 119, "organization_score_max")
model.addConstr(15 * peggy_hours + 24 * bobby_hours <= 59, "work_quality_max")
model.addConstr(19 * peggy_hours + 2 * bobby_hours <= 199, "paperwork_max")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Peggy's hours: {peggy_hours.x}")
    print(f"  Bobby's hours: {bobby_hours.x}")
    print(f"  Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

