
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Peggy")
x1 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Bobby")

# Objective function: Maximize 2*x0 + 7*x1
m.setObjective(2*x0 + 7*x1, GRB.MAXIMIZE)

# Constraints
m.addConstr(4*x0 + 14*x1 >= 65, "organization_score_min")
m.addConstr(4*x0 + 14*x1 <= 119, "organization_score_max")
m.addConstr(15*x0 + 24*x1 >= 22, "work_quality_rating_min")
m.addConstr(15*x0 + 24*x1 <= 59, "work_quality_rating_max")
m.addConstr(19*x0 + 2*x1 >= 72, "paperwork_competence_rating_min")
m.addConstr(19*x0 + 2*x1 <= 199, "paperwork_competence_rating_max")
m.addConstr(-4*x0 + 6*x1 >= 0, "additional_linear_constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Peggy: {x0.x}")
    print(f"Hours worked by Bobby: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
