
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
peggy_hours = m.addVar(name="peggy_hours", lb=0)  # Non-integer, so no specific type needed
bobby_hours = m.addVar(name="bobby_hours", lb=0, type=gp.GRB.INTEGER)  # Integer

# Objective function: Maximize 2*peggy_hours + 7*bobby_hours
m.setObjective(2 * peggy_hours + 7 * bobby_hours, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(4 * peggy_hours + 14 * bobby_hours >= 65, name="org_score_min")
m.addConstr(15 * peggy_hours + 24 * bobby_hours >= 22, name="work_quality_min")
m.addConstr(19 * peggy_hours + 2 * bobby_hours >= 72, name="paperwork_competence_min")
m.addConstr(-4 * peggy_hours + 6 * bobby_hours >= 0, name="linear_constraint")
m.addConstr(4 * peggy_hours + 14 * bobby_hours <= 119, name="org_score_max")
m.addConstr(15 * peggy_hours + 24 * bobby_hours <= 59, name="work_quality_max")
m.addConstr(19 * peggy_hours + 2 * bobby_hours <= 199, name="paperwork_competence_max")

# Solve the model
m.solve()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Peggy hours: {peggy_hours.varValue}")
    print(f"Bobby hours: {bobby_hours.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
