
import gurobipy as gp

# Create a new model
m = gp.Model("Work_Optimization")

# Create variables
laura_hours = m.addVar(lb=0, name="laura_hours")
dale_hours = m.addVar(lb=0, name="dale_hours")
mary_hours = m.addVar(lb=0, name="mary_hours")
ringo_hours = m.addVar(lb=0, name="ringo_hours")

# Set objective function
m.setObjective(1 * laura_hours + 2 * dale_hours + 9 * mary_hours + 1 * ringo_hours, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3.13 * laura_hours + 5.7 * dale_hours >= 43, "c1")
m.addConstr(3.13 * laura_hours + 5.7 * dale_hours + 7.03 * ringo_hours >= 28, "c2")
m.addConstr(8.68 * laura_hours + 7.47 * dale_hours >= 60, "c3")
m.addConstr(7.47 * dale_hours + 5.15 * ringo_hours >= 77, "c4")
m.addConstr(4.0 * mary_hours + 7.03 * ringo_hours <= 166, "c5")
m.addConstr(3.13 * laura_hours + 5.7 * dale_hours <= 98, "c6")
m.addConstr(5.7 * dale_hours + 7.03 * ringo_hours <= 115, "c7")
m.addConstr(3.13 * laura_hours + 7.03 * ringo_hours <= 190, "c8")
m.addConstr(5.7 * dale_hours + 4.0 * mary_hours <= 116, "c9")
m.addConstr(5.7 * dale_hours + 4.0 * mary_hours + 7.03 * ringo_hours <= 143, "c10")
m.addConstr(3.13 * laura_hours + 4.0 * mary_hours + 7.03 * ringo_hours <= 67, "c11")
m.addConstr(3.13 * laura_hours + 5.7 * dale_hours + 4.0 * mary_hours + 7.03 * ringo_hours <= 67, "c12")
m.addConstr(5.79 * laura_hours + 4.21 * dale_hours <= 144, "c13")
m.addConstr(9.35 * mary_hours + 5.22 * ringo_hours <= 120, "c14")
m.addConstr(5.79 * laura_hours + 5.22 * ringo_hours <= 198, "c15")
m.addConstr(5.79 * laura_hours + 9.35 * mary_hours + 5.22 * ringo_hours <= 85, "c16")
m.addConstr(5.79 * laura_hours + 4.21 * dale_hours + 9.35 * mary_hours <= 146, "c17")
m.addConstr(4.21 * dale_hours + 9.35 * mary_hours + 5.22 * ringo_hours <= 59, "c18")
m.addConstr(5.79 * laura_hours + 4.21 * dale_hours + 9.35 * mary_hours + 5.22 * ringo_hours <= 59, "c19")
m.addConstr(8.68 * laura_hours + 7.47 * dale_hours <= 84, "c20")
m.addConstr(1.57 * mary_hours + 5.15 * ringo_hours <= 115, "c21")
m.addConstr(8.68 * laura_hours + 5.15 * ringo_hours <= 213, "c22")
m.addConstr(7.47 * dale_hours + 1.57 * mary_hours <= 114, "c23")
m.addConstr(7.47 * dale_hours + 5.15 * ringo_hours <= 311, "c24")
m.addConstr(8.68 * laura_hours + 7.47 * dale_hours + 1.57 * mary_hours <= 229, "c25")
m.addConstr(8.68 * laura_hours + 7.47 * dale_hours + 5.15 * ringo_hours <= 221, "c26")
m.addConstr(8.68 * laura_hours + 1.57 * mary_hours + 5.15 * ringo_hours <= 243, "c27")
m.addConstr(8.68 * laura_hours + 7.47 * dale_hours + 1.57 * mary_hours + 5.15 * ringo_hours <= 243, "c28")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)
