
import gurobipy as gp

# Create a new model
model = gp.Model("optimization_problem")

# Create variables
postage_stamps = model.addVar(vtype=gp.GRB.INTEGER, name="postage_stamps")
paper_clips = model.addVar(vtype=gp.GRB.INTEGER, name="paper_clips")
headsets = model.addVar(vtype=gp.GRB.INTEGER, name="headsets")

# Set objective function
model.setObjective(7.71 * postage_stamps + 6.19 * paper_clips + 5.07 * headsets, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(4.49 * postage_stamps + 1.38 * headsets >= 50, "c1")
model.addConstr(3.37 * paper_clips + 1.38 * headsets >= 38, "c2")
model.addConstr(4.49 * postage_stamps + 3.37 * paper_clips + 1.38 * headsets >= 67, "c3")
model.addConstr(6 * postage_stamps - 6 * paper_clips >= 0, "c4")
model.addConstr(4 * postage_stamps - 5 * headsets >= 0, "c5")


# Add upper bound constraint on total cost
model.addConstr(4.49 * postage_stamps + 3.37 * paper_clips + 1.38 * headsets <= 233, "c6")


# Optimize model
model.optimize()

# Check for infeasibility
if model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal Solution:")
    print(f"Postage Stamps: {postage_stamps.x}")
    print(f"Paper Clips: {paper_clips.x}")
    print(f"Headsets: {headsets.x}")
    print(f"Objective Value: {model.objVal}")

