
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Create variables
postage_stamps = m.addVar(vtype=GRB.INTEGER, name="postage_stamps")
paper_clips = m.addVar(vtype=GRB.INTEGER, name="paper_clips")
headsets = m.addVar(vtype=GRB.INTEGER, name="headsets")

# Set the objective function
m.setObjective(7.71*postage_stamps + 6.19*paper_clips + 5.07*headsets, GRB.MINIMIZE)

# Add constraints
m.addConstr(4.49*postage_stamps + 1.38*headsets >= 50, "postage_and_headsets")
m.addConstr(3.37*paper_clips + 1.38*headsets >= 38, "paperclips_and_headsets")
m.addConstr(4.49*postage_stamps + 3.37*paper_clips + 1.38*headsets >= 67, "all_items_together")
m.addConstr(6*postage_stamps - 6*paper_clips >= 0, "postage_vs_paperclips")
m.addConstr(4*postage_stamps - 5*headsets >= 0, "postage_vs_headsets")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Postage Stamps: {postage_stamps.x}")
    print(f"Paper Clips: {paper_clips.x}")
    print(f"Headsets: {headsets.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
