
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
postage_stamps = m.addVar(name="postage_stamps", vtype=gp.GRB.INTEGER)
paper_clips = m.addVar(name="paper_clips", vtype=gp.GRB.INTEGER)
headsets = m.addVar(name="headsets", vtype=gp.GRB.INTEGER)

# Objective function
m.setObjective(7.71 * postage_stamps + 6.19 * paper_clips + 5.07 * headsets, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(4.49 * postage_stamps + 1.38 * headsets >= 50, name="postage_stamps_headsets_min_spend")
m.addConstr(3.37 * paper_clips + 1.38 * headsets >= 38, name="paper_clips_headsets_min_spend")
m.addConstr(4.49 * postage_stamps + 3.37 * paper_clips + 1.38 * headsets >= 67, name="total_min_spend")
m.addConstr(6 * postage_stamps - 6 * paper_clips >= 0, name="postage_stamps_paper_clips_ratio")
m.addConstr(4 * postage_stamps - 5 * headsets >= 0, name="postage_stamps_headsets_ratio")

# Solve the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Postage stamps: {postage_stamps.varValue}")
    print(f"Paper clips: {paper_clips.varValue}")
    print(f"Headsets: {headsets.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
