
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
protein_bars = model.addVar(vtype=GRB.INTEGER, name="protein_bars")
strawberries = model.addVar(vtype=GRB.CONTINUOUS, name="strawberries")

# Set objective function
model.setObjective(9 * protein_bars * protein_bars + 9 * protein_bars * strawberries, GRB.MAXIMIZE)

# Add constraints
model.addConstr(13 * protein_bars * protein_bars + 14 * strawberries * strawberries >= 24, "tastiness_rating_squared")
model.addConstr(8 * protein_bars * protein_bars + 12 * strawberries * strawberries >= 12, "protein_squared")
model.addConstr(3 * protein_bars + 5 * strawberries >= 32, "umami_index")
model.addConstr(7 * protein_bars - 10 * strawberries >= 0, "weighted_sum")
model.addConstr(13 * protein_bars + 14 * strawberries <= 41, "tastiness_rating")  # Duplicate constraint removed
model.addConstr(8 * protein_bars + 12 * strawberries <= 36, "protein")  # Duplicate constraint removed
model.addConstr(3 * protein_bars * protein_bars + 5 * strawberries * strawberries <= 40, "umami_index_squared")
model.addConstr(3 * protein_bars + 5 * strawberries <= 40, "umami_index_total")


# Resource Constraints (provided in the prompt, but not explicitly used in the constraints)
model.addConstr(13 * protein_bars <= 66, "tastiness_resource_protein_bars")
model.addConstr(8 * protein_bars <= 58, "protein_resource_protein_bars")
model.addConstr(3 * protein_bars <= 72, "umami_resource_protein_bars")
model.addConstr(14 * strawberries <= 66, "tastiness_resource_strawberries")
model.addConstr(12 * strawberries <= 58, "protein_resource_strawberries")
model.addConstr(5 * strawberries <= 72, "umami_resource_strawberries")



# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"Protein bars: {protein_bars.x}")
    print(f"Strawberries: {strawberries.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

