
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("protein_bars_strawberries")

# Define variables
protein_bars = model.addVar(vtype=GRB.INTEGER, name="protein_bars")
strawberries = model.addVar(vtype=GRB.CONTINUOUS, name="strawberries")

# Objective function
model.setObjective(9 * protein_bars ** 2 + 9 * protein_bars * strawberries, GRB.MAXIMIZE)

# Constraints
model.addConstr(protein_bars >= 0, name="protein_bars_non_negative")
model.addConstr(strawberries >= 0, name="strawberries_non_negative")

# Constraint 7: Total combined tastiness rating squared
model.addConstr(13 ** 2 * protein_bars ** 2 + 14 ** 2 * strawberries ** 2 >= 24, name="tastiness_rating_squared")

# Constraint 8: Total combined grams of protein squared
model.addConstr(8 ** 2 * protein_bars ** 2 + 12 ** 2 * strawberries ** 2 >= 12, name="grams_protein_squared")

# Constraint 9: Total combined umami index
model.addConstr(3 * protein_bars + 5 * strawberries >= 32, name="umami_index")

# Constraint 10: 7 * protein bars - 10 * strawberries >= 0
model.addConstr(7 * protein_bars - 10 * strawberries >= 0, name="protein_bars_strawberries_ratio")

# Constraint 11 & 12: Total combined tastiness rating
model.addConstr(13 * protein_bars + 14 * strawberries <= 41, name="total_tastiness_rating")

# Constraint 13 & 14: Total combined grams of protein
model.addConstr(8 * protein_bars + 12 * strawberries <= 36, name="total_grams_protein")

# Constraint 15: Total combined umami index squared
model.addConstr(3 ** 2 * protein_bars ** 2 + 5 ** 2 * strawberries ** 2 <= 40, name="umami_index_squared")

# Constraint 16: Total combined umami index
model.addConstr(3 * protein_bars + 5 * strawberries <= 40, name="total_umami_index")

# Solve the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Protein Bars: {protein_bars.varValue}")
    print(f"Strawberries: {strawberries.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("The model is infeasible.")
