
from gurobipy import Model, GRB

# Create a new model
model = Model("Employee_Scheduling")

# Create variables
dale_hours = model.addVar(vtype=GRB.INTEGER, name="dale_hours")
hank_hours = model.addVar(vtype=GRB.INTEGER, name="hank_hours")
bill_hours = model.addVar(vtype=GRB.INTEGER, name="bill_hours")

# Set objective function
model.setObjective(1 * dale_hours + 5 * hank_hours + 5 * bill_hours, GRB.MAXIMIZE)

# Add constraints
model.addConstr(9 * dale_hours + 3 * hank_hours >= 6, "c1")
model.addConstr(9 * dale_hours + 3 * hank_hours + 11 * bill_hours >= 12, "c2")
model.addConstr(5 * hank_hours + 5 * bill_hours >= 19, "c3")
model.addConstr(10 * dale_hours + 5 * hank_hours >= 17, "c4")
model.addConstr(10 * dale_hours + 5 * hank_hours + 5 * bill_hours >= 26, "c5")
model.addConstr(4 * dale_hours + 5 * hank_hours + 8 * bill_hours >= 27, "c6")
model.addConstr(14 * dale_hours + 12 * bill_hours >= 5, "c7")
model.addConstr(14 * dale_hours + 9 * hank_hours >= 9, "c8")
model.addConstr(9 * dale_hours + 13 * bill_hours >= 8, "c9")
model.addConstr(9 * dale_hours + 1 * hank_hours >= 6, "c10")
model.addConstr(3 * hank_hours + 11 * bill_hours <= 41, "c11")
model.addConstr(9 * dale_hours + 3 * hank_hours <= 47, "c12")
model.addConstr(9 * dale_hours + 3 * hank_hours + 11 * bill_hours <= 38, "c13")
model.addConstr(10 * dale_hours + 5 * bill_hours <= 37, "c14")
model.addConstr(10 * dale_hours + 5 * hank_hours <= 57, "c15")
model.addConstr(10 * dale_hours + 5 * hank_hours + 5 * bill_hours <= 57, "c16")
model.addConstr(5 * hank_hours + 8 * bill_hours <= 103, "c17")
model.addConstr(4 * dale_hours + 5 * hank_hours <= 78, "c18")
model.addConstr(4 * dale_hours + 5 * hank_hours + 8 * bill_hours <= 78, "c19")
model.addConstr(14 * dale_hours + 9 * hank_hours <= 21, "c20")
model.addConstr(14 * dale_hours + 12 * bill_hours <= 22, "c21")
model.addConstr(14 * dale_hours + 9 * hank_hours + 12 * bill_hours <= 22, "c22")
model.addConstr(9 * dale_hours + 13 * bill_hours <= 43, "c23")
model.addConstr(9 * dale_hours + 1 * hank_hours + 13 * bill_hours <= 43, "c24")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('Dale Hours: %g' % dale_hours.x)
    print('Hank Hours: %g' % hank_hours.x)
    print('Bill Hours: %g' % bill_hours.x)
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")
