
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
hours_worked_by_Dale = model.addVar(name="hours_worked_by_Dale", vtype=gurobi.GRB.INTEGER)
hours_worked_by_Hank = model.addVar(name="hours_worked_by_Hank", vtype=gurobi.GRB.INTEGER)
hours_worked_by_Bill = model.addVar(name="hours_worked_by_Bill", vtype=gurobi.GRB.INTEGER)

# Objective function
model.setObjective(hours_worked_by_Dale + 5 * hours_worked_by_Hank + 5 * hours_worked_by_Bill, gurobi.GRB.MAXIMIZE)

# Constraints
# Individual attribute constraints (not explicitly needed as they are constants)
# However, we need to ensure the following constraints are met:

# Computer competence rating constraints
model.addConstr(9 * hours_worked_by_Dale + 3 * hours_worked_by_Hank >= 6, name="comp_comp_Dale_Hank")
model.addConstr(9 * hours_worked_by_Dale + 3 * hours_worked_by_Hank + 11 * hours_worked_by_Bill >= 12, name="comp_comp_all")
model.addConstr(3 * hours_worked_by_Hank + 11 * hours_worked_by_Bill <= 41, name="comp_comp_Hank_Bill")
model.addConstr(9 * hours_worked_by_Dale + 3 * hours_worked_by_Hank <= 47, name="comp_comp_Dale_Hank_limit")
model.addConstr(9 * hours_worked_by_Dale + 3 * hours_worked_by_Hank + 11 * hours_worked_by_Bill <= 38, name="comp_comp_all_limit")

# Dollar cost per hour constraints
model.addConstr(5 * hours_worked_by_Hank + 5 * hours_worked_by_Bill >= 19, name="dollar_cost_Hank_Bill")
model.addConstr(10 * hours_worked_by_Dale + 5 * hours_worked_by_Hank >= 17, name="dollar_cost_Dale_Hank")
model.addConstr(10 * hours_worked_by_Dale + 5 * hours_worked_by_Hank + 5 * hours_worked_by_Bill >= 26, name="dollar_cost_all")
model.addConstr(10 * hours_worked_by_Dale + 5 * hours_worked_by_Bill <= 37, name="dollar_cost_Dale_Bill_limit")
model.addConstr(10 * hours_worked_by_Dale + 5 * hours_worked_by_Hank <= 57, name="dollar_cost_Dale_Hank_limit")
model.addConstr(10 * hours_worked_by_Dale + 5 * hours_worked_by_Hank + 5 * hours_worked_by_Bill <= 57, name="dollar_cost_all_limit")

# Productivity rating constraints
model.addConstr(4 * hours_worked_by_Dale + 5 * hours_worked_by_Hank + 8 * hours_worked_by_Bill >= 27, name="productivity_all")
model.addConstr(5 * hours_worked_by_Hank + 8 * hours_worked_by_Bill <= 103, name="productivity_Hank_Bill_limit")
model.addConstr(4 * hours_worked_by_Dale + 5 * hours_worked_by_Hank <= 78, name="productivity_Dale_Hank_limit")
model.addConstr(4 * hours_worked_by_Dale + 5 * hours_worked_by_Hank + 8 * hours_worked_by_Bill <= 78, name="productivity_all_limit")

# Likelihood to quit index constraints
model.addConstr(14 * hours_worked_by_Dale + 12 * hours_worked_by_Bill >= 5, name="quit_index_Dale_Bill")
model.addConstr(14 * hours_worked_by_Dale + 9 * hours_worked_by_Hank >= 9, name="quit_index_Dale_Hank")
model.addConstr(14 * hours_worked_by_Dale + 9 * hours_worked_by_Hank + 12 * hours_worked_by_Bill <= 22, name="quit_index_all_limit")
model.addConstr(14 * hours_worked_by_Dale + 9 * hours_worked_by_Hank <= 21, name="quit_index_Dale_Hank_limit")
model.addConstr(14 * hours_worked_by_Dale + 12 * hours_worked_by_Bill <= 22, name="quit_index_Dale_Bill_limit")

# Organization score constraints
model.addConstr(9 * hours_worked_by_Dale + 13 * hours_worked_by_Bill >= 8, name="org_score_Dale_Bill")
model.addConstr(9 * hours_worked_by_Dale + hours_worked_by_Hank >= 6, name="org_score_Dale_Hank")
model.addConstr(9 * hours_worked_by_Dale + hours_worked_by_Hank + 13 * hours_worked_by_Bill <= 43, name="org_score_all_limit")
model.addConstr(9 * hours_worked_by_Dale + 13 * hours_worked_by_Bill <= 43, name="org_score_Dale_Bill_limit")

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Hours worked by Dale: {hours_worked_by_Dale.varValue}")
    print(f"Hours worked by Hank: {hours_worked_by_Hank.varValue}")
    print(f"Hours worked by Bill: {hours_worked_by_Bill.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
