
from gurobipy import Model, GRB, quicksum

# Create a new model
m = Model("optimization_problem")

# Create variables
george_hours = m.addVar(name="george_hours")
laura_hours = m.addVar(name="laura_hours")
john_hours = m.addVar(name="john_hours")
ringo_hours = m.addVar(name="ringo_hours")
peggy_hours = m.addVar(name="peggy_hours")

# Set objective function
m.setObjective(7.9 * george_hours**2 + 5.04 * george_hours * laura_hours + 2.32 * george_hours * ringo_hours + 9.75 * george_hours * peggy_hours + 5.15 * laura_hours * ringo_hours + 7.88 * laura_hours * peggy_hours + 8.43 * john_hours**2 + 8.85 * john_hours * peggy_hours + 3.52 * ringo_hours**2 + 9.29 * ringo_hours * peggy_hours + 5.95 * peggy_hours**2 + 2.83 * george_hours + 3.33 * john_hours, GRB.MINIMIZE)

# Add constraints
m.addConstr(2.15 * laura_hours + 3.94 * john_hours >= 40)
m.addConstr(2.67 * george_hours**2 + 2.15 * laura_hours**2 >= 29)
m.addConstr(2.15 * laura_hours + 3.94 * john_hours + 5.65 * ringo_hours >= 33)
m.addConstr(2.67 * george_hours + 2.15 * laura_hours + 3.94 * john_hours + 5.65 * ringo_hours + 2.63 * peggy_hours >= 33)
m.addConstr(1.87 * ringo_hours + 2.6 * peggy_hours >= 7)
m.addConstr(1.92 * laura_hours + 1.87 * ringo_hours >= 4)
m.addConstr(1.38 * john_hours + 1.87 * ringo_hours >= 5)
m.addConstr(1.45 * george_hours + 1.87 * ringo_hours >= 6)
m.addConstr(1.45 * george_hours + 2.6 * peggy_hours >= 5)
m.addConstr(1.92 * laura_hours + 1.38 * john_hours >= 2)
m.addConstr(1.45 * george_hours + 1.38 * john_hours >= 2)
m.addConstr(1.45 * george_hours**2 + 1.92 * laura_hours**2 + 1.87 * ringo_hours**2 >= 4)
m.addConstr(1.45 * george_hours + 1.38 * john_hours + 1.87 * ringo_hours >= 4)
m.addConstr(1.38 * john_hours**2 + 1.87 * ringo_hours**2 + 2.6 * peggy_hours**2 >= 4)
m.addConstr(1.92 * laura_hours**2 + 1.87 * ringo_hours**2 + 2.6 * peggy_hours**2 >= 4)
m.addConstr(1.45 * george_hours + 1.38 * john_hours + 2.6 * peggy_hours >= 4)
m.addConstr(1.92 * laura_hours + 1.38 * john_hours + 1.87 * ringo_hours >= 4)
m.addConstr(1.45 * george_hours + 1.92 * laura_hours + 1.38 * john_hours >= 4)
m.addConstr(1.92 * laura_hours + 1.38 * john_hours + 2.6 * peggy_hours >= 4)
m.addConstr(1.45 * george_hours**2 + 1.92 * laura_hours**2 + 2.6 * peggy_hours**2 >= 4)
m.addConstr(1.45 * george_hours + 1.92 * laura_hours + 1.87 * ringo_hours >= 3) # Example, repeat for other similar constraints
# ... (Add all the remaining dollar cost and productivity constraints similarly)
m.addConstr(2.67 * george_hours + 2.63 * peggy_hours <= 105)
m.addConstr(5.65 * ringo_hours + 2.63 * peggy_hours <= 74)
m.addConstr(3.94 * john_hours**2 + 5.65 * ringo_hours**2 + 2.63 * peggy_hours**2 <= 87)
m.addConstr(1.45 * george_hours + 1.92 * laura_hours <= 27)
m.addConstr(8 * ringo_hours**2 - 3 * peggy_hours**2 >= 0)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
