
from gurobipy import *

# Create a new model
m = Model("Work Hours Optimization")

# Define variables
G = m.addVar(vtype=GRB.CONTINUOUS, name="George")
L = m.addVar(vtype=GRB.CONTINUOUS, name="Laura")
J = m.addVar(vtype=GRB.CONTINUOUS, name="John")
R = m.addVar(vtype=GRB.CONTINUOUS, name="Ringo")
P = m.addVar(vtype=GRB.CONTINUOUS, name="Peggy")

# Objective function
m.setObjective(7*G**2 + 5*L**2 + 3*J**2 + 8*R**2 - 3*P**2, GRB.MINIMIZE)

# Constraints (a selection for demonstration; add all constraints as per the problem)
m.addConstr(G + P <= 105)  # Total combined productivity rating from George and Peggy
m.addConstr(R + P <= 74)    # Total combined productivity rating from Ringo and Peggy
m.addConstr(J**2 + R**2 + P**2 <= 87)  # Combined productivity rating squared from John, Ringo, and Peggy
m.addConstr(G + L <= 27)    # Dollar cost per hour constraint for George and Laura

# Additional constraints based on problem description (example)
m.addConstr(8*R**2 - 3*P**2 >= 0)

# Solve the model
m.optimize()

# Print solution
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print(f"Objective: {m.objVal}")
