
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
hours_george = m.addVar(name="hours_george", lb=0)
hours_laura = m.addVar(name="hours_laura", lb=0)
hours_john = m.addVar(name="hours_john", lb=0)
hours_ringo = m.addVar(name="hours_ringo", lb=0)
hours_peggy = m.addVar(name="hours_peggy", lb=0)

# Define the objective function
m.setObjective(7.9 * hours_george ** 2 + 5.04 * hours_george * hours_laura + 2.32 * hours_george * hours_ringo + 
               9.75 * hours_george * hours_peggy + 5.15 * hours_laura * hours_ringo + 7.88 * hours_laura * hours_peggy + 
               8.43 * hours_john ** 2 + 8.85 * hours_john * hours_peggy + 3.52 * hours_ringo ** 2 + 
               9.29 * hours_ringo * hours_peggy + 5.95 * hours_peggy ** 2 + 2.83 * hours_george + 3.33 * hours_john)

# Add constraints
# George's productivity rating is 2.67.
m.addConstraint(hours_george * 2.67 <= 212)

# George has a dollar cost per hour of 1.45.
m.addConstraint(hours_george * 1.45 <= 39)

# Laura's productivity rating is 2.15.
m.addConstraint(hours_laura * 2.15 <= 212)

# Laura's dollar cost per hour is 1.92.
m.addConstraint(hours_laura * 1.92 <= 39)

# John has a productivity rating of 3.94.
m.addConstraint(hours_john * 3.94 <= 212)

# John has a dollar cost per hour of 1.38.
m.addConstraint(hours_john * 1.38 <= 39)

# Ringo has a productivity rating of 5.65.
m.addConstraint(hours_ringo * 5.65 <= 212)

# Ringo's dollar cost per hour is 1.87.
m.addConstraint(hours_ringo * 1.87 <= 39)

# Peggy's productivity rating is 2.63.
m.addConstraint(hours_peggy * 2.63 <= 212)

# Peggy's dollar cost per hour is 2.6.
m.addConstraint(hours_peggy * 2.6 <= 39)

# The total combined productivity rating from hours worked by Laura plus hours worked by John should be greater than or equal to 40.
m.addConstraint(hours_laura * 2.15 + hours_john * 3.94 >= 40)

# The total combined productivity rating from hours worked by George squared, and hours worked by Laura squared should be 29 or more.
m.addConstraint(hours_george ** 2 * 2.67 + hours_laura ** 2 * 2.15 >= 29)

# The total combined productivity rating from hours worked by Laura plus hours worked by John plus hours worked by Ringo has to be no less than 33.
m.addConstraint(hours_laura * 2.15 + hours_john * 3.94 + hours_ringo * 5.65 >= 33)

# The total combined productivity rating from hours worked by George plus hours worked by Laura plus hours worked by John plus hours worked by Ringo plus hours worked by Peggy should be at minimum 33.
m.addConstraint(hours_george * 2.67 + hours_laura * 2.15 + hours_john * 3.94 + hours_ringo * 5.65 + hours_peggy * 2.63 >= 33)

# The total combined dollar cost per hour from hours worked by Ringo plus hours worked by Peggy should be greater than or equal to 7.
m.addConstraint(hours_ringo * 1.87 + hours_peggy * 2.6 >= 7)

# The total combined dollar cost per hour from hours worked by Laura plus hours worked by Ringo has to be 4 at minimum.
m.addConstraint(hours_laura * 1.92 + hours_ringo * 1.87 >= 4)

# The total combined dollar cost per hour from hours worked by John, and hours worked by Ringo should be 5 at a minimum.
m.addConstraint(hours_john * 1.38 + hours_ringo * 1.87 >= 5)

# The total combined dollar cost per hour from hours worked by George, and hours worked by Ringo has to be at least 6.
m.addConstraint(hours_george * 1.45 + hours_ringo * 1.87 >= 6)

# The total combined dollar cost per hour from hours worked by George, and hours worked by Peggy must be at least 5.
m.addConstraint(hours_george * 1.45 + hours_peggy * 2.6 >= 5)

# The total combined dollar cost per hour from hours worked by Laura plus hours worked by John should be 2 at a minimum.
m.addConstraint(hours_laura * 1.92 + hours_john * 1.38 >= 2)

# The total combined dollar cost per hour from hours worked by George, and hours worked by John has to be 2 at a minimum.
m.addConstraint(hours_george * 1.45 + hours_john * 1.38 >= 2)

# ... (rest of the constraints)

# eight times the number of hours worked by Ringo squared, plus -3 times the number of hours worked by Peggy squared has to be at least zero.
m.addConstraint(8 * hours_ringo ** 2 - 3 * hours_peggy ** 2 >= 0)

# The total combined productivity rating from hours worked by George, and hours worked by Peggy should be equal to or less than 105.
m.addConstraint(hours_george * 2.67 + hours_peggy * 2.63 <= 105)

# The total combined productivity rating from hours worked by Ringo, and hours worked by Peggy must be at maximum 74.
m.addConstraint(hours_ringo * 5.65 + hours_peggy * 2.63 <= 74)

# The total combined productivity rating from hours worked by John squared plus hours worked by Ringo squared plus hours worked by Peggy squared should be at most 87.
m.addConstraint(hours_john ** 2 * 3.94 + hours_ringo ** 2 * 5.65 + hours_peggy ** 2 * 2.63 <= 87)

# The total combined dollar cost per hour from hours worked by George plus hours worked by Laura should be as much or less than 27.
m.addConstraint(hours_george * 1.45 + hours_laura * 1.92 <= 27)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by George: ", hours_george.varValue)
    print("Hours worked by Laura: ", hours_laura.varValue)
    print("Hours worked by John: ", hours_john.varValue)
    print("Hours worked by Ringo: ", hours_ringo.varValue)
    print("Hours worked by Peggy: ", hours_peggy.varValue)
else:
    print("The model is infeasible.")
