
from gurobipy import Model, GRB

# Create a new model
model = Model("Minimize Labor Cost")

# Create variables
ringo_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="ringo_hours")
hank_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hank_hours")
laura_hours = model.addVar(lb=0, vtype=GRB.INTEGER, name="laura_hours")

# Set objective function
model.setObjective(4.1 * ringo_hours + 6.3 * hank_hours + 7.72 * laura_hours, GRB.MINIMIZE)

# Add constraints
model.addConstr(7 * ringo_hours + 10 * laura_hours >= 19, "c1")
model.addConstr(7 * ringo_hours + 14 * hank_hours >= 20, "c2")
model.addConstr(7 * ringo_hours + 14 * hank_hours + 10 * laura_hours >= 20, "c3")
model.addConstr(6 * hank_hours - 4 * laura_hours >= 0, "c4")
model.addConstr(7 * ringo_hours + 14 * hank_hours <= 52, "c5")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('Ringo Hours: %g' % ringo_hours.x)
    print('Hank Hours: %g' % hank_hours.x)
    print('Laura Hours: %g' % laura_hours.x)
elif model.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % model.status)
