
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define the variables
Ringo_hours = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Ringo")
Hank_hours = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Hank")
Laura_hours = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Laura")

# Define the objective function
m.setObjective(4.1 * Ringo_hours + 6.3 * Hank_hours + 7.72 * Laura_hours, GRB.MINIMIZE)

# Define the constraints
m.addConstr(7 * Ringo_hours + 10 * Laura_hours >= 19, name="Ringo_Laura_min_19")
m.addConstr(7 * Ringo_hours + 14 * Hank_hours >= 20, name="Ringo_Hank_min_20")
m.addConstr(7 * Ringo_hours + 14 * Hank_hours + 10 * Laura_hours >= 20, name="All_min_20")
m.addConstr(6 * Hank_hours - 4 * Laura_hours >= 0, name="Hank_Laura_ratio")
m.addConstr(7 * Ringo_hours + 14 * Hank_hours <= 52, name="Ringo_Hank_max_52")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Ringo: {Ringo_hours.x}")
    print(f"Hours worked by Hank: {Hank_hours.x}")
    print(f"Hours worked by Laura: {Laura_hours.x}")
else:
    print("No optimal solution found")
