
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    R = model.addVar(name="Ringo_hours", lb=0)  # Ringo's hours can be fractional
    H = model.addVar(name="Hank_hours", lb=0)  # Hank's hours can be fractional
    L = model.addVar(name="Laura_hours", lb=0, vtype=gurobi.GRB.INTEGER)  # Laura's hours must be an integer

    # Objective function
    model.setObjective(4.1 * R + 6.3 * H + 7.72 * L, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(7 * R + 10 * L >= 19, name="R_L_competence")
    model.addConstr(7 * R + 14 * H >= 20, name="R_H_competence")
    model.addConstr(7 * R + 14 * H + 10 * L >= 20, name="R_H_L_competence")
    model.addConstr(6 * H - 4 * L >= 0, name="H_L_tradeoff")
    model.addConstr(7 * R + 14 * H <= 52, name="R_H_budget")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Ringo's hours: {R.varValue}")
        print(f"Hank's hours: {H.varValue}")
        print(f"Laura's hours: {L.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
