
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_a = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_a")
vitamin_b5 = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_b5")
vitamin_b3 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_b3")
iron = m.addVar(vtype=gp.GRB.CONTINUOUS, name="iron")

# Set objective function
m.setObjective(9.87 * vitamin_a + 2.03 * vitamin_b5 + 7.26 * vitamin_b3 + 4.87 * iron, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(29 * vitamin_b5 + 29 * iron >= 26, "c1")
m.addConstr(29 * vitamin_a + 29 * iron >= 41, "c2")
m.addConstr(29 * vitamin_a + 21 * vitamin_b5 >= 27, "c3")
m.addConstr(21 * vitamin_b5 + 31 * vitamin_b3 >= 71, "c4")
m.addConstr(31 * vitamin_b3 + 29 * iron >= 31, "c5")
m.addConstr(29 * vitamin_a + 31 * vitamin_b3 >= 39, "c6")
m.addConstr(21 * vitamin_b5 + 31 * vitamin_b3 + 29 * iron >= 56, "c7")
m.addConstr(29 * vitamin_a + 21 * vitamin_b5 + 31 * vitamin_b3 + 29 * iron >= 56, "c8")
m.addConstr(7 * vitamin_b5 - 4 * iron >= 0, "c9")
m.addConstr(21 * vitamin_b5 + 31 * vitamin_b3 <= 293, "c10")
m.addConstr(29 * vitamin_a + 31 * vitamin_b3 <= 184, "c11")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('vitamin_a:', vitamin_a.x)
    print('vitamin_b5:', vitamin_b5.x)
    print('vitamin_b3:', vitamin_b3.x)
    print('iron:', iron.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

