
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="vitamin_A")
x1 = m.addVar(vtype=GRB.INTEGER, name="vitamin_B5")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="vitamin_B3")
x3 = m.addVar(vtype=GRB.CONTINUOUS, name="iron")

# Objective function
m.setObjective(9.87*x0 + 2.03*x1 + 7.26*x2 + 4.87*x3, GRB.MINIMIZE)

# Constraints
m.addConstr(21*x1 + 29*x3 >= 26, "muscle_growth_index_1")
m.addConstr(29*x0 + 29*x3 >= 41, "muscle_growth_index_2")
m.addConstr(29*x0 + 21*x1 >= 27, "muscle_growth_index_3")
m.addConstr(21*x1 + 31*x2 >= 71, "muscle_growth_index_4")
m.addConstr(31*x2 + 29*x3 >= 31, "muscle_growth_index_5")
m.addConstr(29*x0 + 31*x2 >= 39, "muscle_growth_index_6")
m.addConstr(21*x1 + 31*x2 + 29*x3 >= 56, "muscle_growth_index_7")
m.addConstr(29*x0 + 21*x1 + 31*x2 + 29*x3 >= 56, "total_muscle_growth_index")
m.addConstr(7*x1 - 4*x3 >= 0, "linear_constraint")
m.addConstr(21*x1 + 31*x2 <= 293, "upper_bound_1")
m.addConstr(29*x0 + 31*x2 <= 184, "upper_bound_2")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Vitamin A: {x0.x}")
    print(f"Vitamin B5: {x1.x}")
    print(f"Vitamin B3: {x2.x}")
    print(f"Iron: {x3.x}")
else:
    print("No optimal solution found")
