
import gurobi as gp

# Create a new model
m = gp.Model("Vitamin_Optimization")

# Define variables
x0 = m.addVar(name="Vitamin_A", vtype=gp.GRB.INTEGER)  # milligrams of vitamin A
x1 = m.addVar(name="Vitamin_B5", vtype=gp.GRB.INTEGER)  # milligrams of vitamin B5
x2 = m.addVar(name="Vitamin_B3")  # milligrams of vitamin B3
x3 = m.addVar(name="Iron")  # milligrams of iron

# Objective function
m.setObjective(9.87*x0 + 2.03*x1 + 7.26*x2 + 4.87*x3, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(x1 + x3 >= 26)
m.addConstr(x0 + x3 >= 41)
m.addConstr(x0 + x1 >= 27)
m.addConstr(x1 + x2 >= 71)
m.addConstr(x2 + x3 >= 31)
m.addConstr(x0 + x2 >= 39)
m.addConstr(x1 + x2 + x3 >= 56)
m.addConstr(x0 + x1 + x2 + x3 >= 56)
m.addConstr(7*x1 - 4*x3 >= 0)
m.addConstr(x1 + x2 <= 293)
m.addConstr(x0 + x2 <= 184)

# Solve the problem
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Vitamin A: {x0.varValue}")
    print(f"Vitamin B5: {x1.varValue}")
    print(f"Vitamin B3: {x2.varValue}")
    print(f"Iron: {x3.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
