
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
fruit_salads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fruit_salads")
pickles = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="pickles")

# Set objective function
m.setObjective(1.26 * fruit_salads + 7.37 * pickles, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(4 * fruit_salads + 19 * pickles >= 69, "iron_minimum")
m.addConstr(2 * fruit_salads - 5 * pickles >= 0, "fruit_salads_pickles_ratio")
m.addConstr(4 * fruit_salads + 19 * pickles <= 186, "iron_maximum")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Fruit Salads: {fruit_salads.x}")
    print(f"  Pickles: {pickles.x}")
    print(f"  Objective Value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

