
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.CONTINUOUS, name="fruit_salads")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="pickles")

# Set the objective function
m.setObjective(1.26*x0 + 7.37*x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x0 + 19*x1 >= 69, "iron_minimum")
m.addConstr(2*x0 - 5*x1 >= 0, "combination_constraint")
m.addConstr(4*x0 + 19*x1 <= 186, "iron_maximum")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of fruit salads: {x0.x}")
    print(f"Number of pickles: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
