
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    fruit_salads = model.addVar(name="fruit_salads", lb=0, ub=None)
    pickles = model.addVar(name="pickles", lb=0, ub=None)

    # Objective function
    model.setObjective(1.26 * fruit_salads + 7.37 * pickles, gurobi.GRB.MAXIMIZE)

    # Constraints
    # Total iron from fruit salads and pickles must be at least 69 milligrams
    model.addConstr(4 * fruit_salads + 19 * pickles >= 69, name="min_iron")

    # 2 times the number of fruit salads, plus -5 times the number of pickles has to be at least zero
    model.addConstr(2 * fruit_salads - 5 * pickles >= 0, name="fruit_pickles_balance")

    # You need to get no more than 205 milligrams of iron from fruit salads and pickles
    model.addConstr(4 * fruit_salads + 19 * pickles <= 205, name="max_iron")

    # Solve the problem
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Fruit Salads: {fruit_salads.varValue}")
        print(f"Pickles: {pickles.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("The problem is infeasible.")

solve_optimization_problem()
