
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    vitamin_k = m.addVar(name="vitamin_k")
    vitamin_e = m.addVar(name="vitamin_e")
    vitamin_a = m.addVar(name="vitamin_a")
    vitamin_b3 = m.addVar(name="vitamin_b3")
    vitamin_b9 = m.addVar(name="vitamin_b9")
    carbohydrates = m.addVar(name="carbohydrates")

    # Set objective function
    obj = (vitamin_k**2 + 6*vitamin_k*vitamin_e + vitamin_k*vitamin_a + 
           vitamin_k*vitamin_b3 + vitamin_k*vitamin_b9 + 6*vitamin_k*carbohydrates +
           4*vitamin_e**2 + 3*vitamin_e*vitamin_b3 + 2*vitamin_a**2 + 
           4*vitamin_a*vitamin_b3 + 7*vitamin_a*vitamin_b9 + 8*vitamin_a*carbohydrates +
           6*vitamin_b3*vitamin_b9 + 7*carbohydrates**2 + 4*vitamin_e + 
           2*vitamin_b3 + 5*vitamin_b9 + 9*carbohydrates)
    m.setObjective(obj, gp.GRB.MINIMIZE)

    # Add constraints
    immune_support_index = {'vitamin_k': 23, 'vitamin_e': 8, 'vitamin_a': 15, 'vitamin_b3': 24, 'vitamin_b9': 26, 'carbohydrates': 8}
    
    m.addConstr(8*vitamin_e**2 + 8*carbohydrates**2 >= 99, "c1")
    m.addConstr(26*vitamin_b9**2 + 8*carbohydrates**2 >= 124, "c2")
    m.addConstr(15*vitamin_a + 24*vitamin_b3 + 8*carbohydrates >= 140, "c3")
    m.addConstr(15*vitamin_a + 26*vitamin_b9 + 8*carbohydrates >= 140, "c4")
    m.addConstr(15*vitamin_a + 24*vitamin_b3 + 26*vitamin_b9 >= 140, "c5")
    m.addConstr(23*vitamin_k**2 + 8*vitamin_e**2 + 15*vitamin_a**2 >= 140, "c6")
    m.addConstr(15*vitamin_a + 24*vitamin_b3 + 8*carbohydrates >= 104, "c7")
    m.addConstr(15*vitamin_a + 26*vitamin_b9 + 8*carbohydrates >= 104, "c8")
    m.addConstr(15*vitamin_a**2 + 24*vitamin_b3**2 + 26*vitamin_b9**2 >= 104, "c9")
    m.addConstr(23*vitamin_k + 8*vitamin_e + 15*vitamin_a >= 104, "c10")
    m.addConstr(15*vitamin_a**2 + 24*vitamin_b3**2 + 8*carbohydrates**2 >= 127, "c11")
    m.addConstr(15*vitamin_a + 26*vitamin_b9 + 8*carbohydrates >= 127, "c12")
    m.addConstr(15*vitamin_a + 24*vitamin_b3 + 26*vitamin_b9 >= 127, "c13")
    m.addConstr(23*vitamin_k + 8*vitamin_e + 15*vitamin_a >= 127, "c14")
    m.addConstr(15*vitamin_a + 24*vitamin_b3 + 8*carbohydrates >= 81, "c15")
    m.addConstr(15*vitamin_a**2 + 26*vitamin_b9**2 + 8*carbohydrates**2 >= 81, "c16")
    m.addConstr(15*vitamin_a + 24*vitamin_b3 + 26*vitamin_b9 >= 81, "c17")
    m.addConstr(23*vitamin_k**2 + 8*vitamin_e**2 + 15*vitamin_a**2 >= 81, "c18")
    m.addConstr(23*vitamin_k + 8*vitamin_e + 15*vitamin_a + 24*vitamin_b3 + 26*vitamin_b9 + 8*carbohydrates >= 81, "c19")
    m.addConstr(-2*vitamin_b9 + 9*carbohydrates >= 0, "c20")
    m.addConstr(-2*vitamin_k - vitamin_b3 + 2*vitamin_b9 >= 0, "c21")
    m.addConstr(8*vitamin_e + 24*vitamin_b3 <= 305, "c22")
    m.addConstr(8*vitamin_e + 8*carbohydrates <= 335, "c23")
    m.addConstr(23*vitamin_k + 15*vitamin_a <= 531, "c24")
    m.addConstr(15*vitamin_a + 24*vitamin_b3 <= 208, "c25")
    m.addConstr(23*vitamin_k + 8*carbohydrates <= 601, "c26")
    m.addConstr(15*vitamin_a + 24*vitamin_b3 + 26*vitamin_b9 <= 611, "c27")
    m.addConstr(23*vitamin_k + 26*vitamin_b9 + 8*carbohydrates <= 595, "c28")
    m.addConstr(8*vitamin_e + 15*vitamin_a + 24*vitamin_b3 <= 292, "c29")
    m.addConstr(15*vitamin_a + 26*vitamin_b9 + 8*carbohydrates <= 681, "c30")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
        print('Obj: %g' % m.objVal)
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
