
import gurobi as gp
from gurobi import GRB

# Define the model
model = gp.Model("optimization_problem")

# Define the variables
milligrams_vitamin_K = model.addVar(lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY, name="milligrams_vitamin_K")
milligrams_vitamin_E = model.addVar(lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY, name="milligrams_vitamin_E")
milligrams_vitamin_A = model.addVar(lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY, name="milligrams_vitamin_A")
milligrams_vitamin_B3 = model.addVar(lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY, name="milligrams_vitamin_B3")
milligrams_vitamin_B9 = model.addVar(lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY, name="milligrams_vitamin_B9")
grams_carbohydrates = model.addVar(lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY, name="grams_carbohydrates")

# Objective function
model.setObjective(milligrams_vitamin_K**2 + 6*milligrams_vitamin_K*milligrams_vitamin_E + 
                   milligrams_vitamin_K*milligrams_vitamin_A + milligrams_vitamin_K*milligrams_vitamin_B3 + 
                   milligrams_vitamin_K*milligrams_vitamin_B9 + 6*milligrams_vitamin_K*grams_carbohydrates +
                   4*milligrams_vitamin_E**2 + 3*milligrams_vitamin_E*milligrams_vitamin_B3 + 
                   2*milligrams_vitamin_A**2 + 4*milligrams_vitamin_A*milligrams_vitamin_B3 + 
                   7*milligrams_vitamin_A*milligrams_vitamin_B9 + 8*milligrams_vitamin_A*grams_carbohydrates +
                   6*milligrams_vitamin_B3*milligrams_vitamin_B9 + 7*grams_carbohydrates**2 +
                   4*milligrams_vitamin_E + 2*milligrams_vitamin_B3 + 5*milligrams_vitamin_B9 + 
                   9*grams_carbohydrates, GRB.MINIMIZE)

# Constraints
model.addConstr(23*milligrams_vitamin_K <= 945, name="immune_support_index_vitamin_K")
model.addConstr(8*milligrams_vitamin_E <= 945, name="immune_support_index_vitamin_E")
model.addConstr(15*milligrams_vitamin_A <= 945, name="immune_support_index_vitamin_A")
model.addConstr(24*milligrams_vitamin_B3 <= 945, name="immune_support_index_vitamin_B3")
model.addConstr(26*milligrams_vitamin_B9 <= 945, name="immune_support_index_vitamin_B9")
model.addConstr(8*grams_carbohydrates <= 945, name="immune_support_index_carbohydrates")

model.addConstr(8*milligrams_vitamin_E**2 + 8*grams_carbohydrates**2 >= 99, name="combined_immune_support_index_E_carbohydrates")
model.addConstr(26*milligrams_vitamin_B9**2 + 8*grams_carbohydrates**2 >= 124, name="combined_immune_support_index_B9_carbohydrates")
model.addConstr(15*milligrams_vitamin_A + 24*milligrams_vitamin_B3 + 8*grams_carbohydrates >= 140, name="combined_immune_support_index_A_B3_carbohydrates")
model.addConstr(15*milligrams_vitamin_A + 26*milligrams_vitamin_B9 + 8*grams_carbohydrates >= 140, name="combined_immune_support_index_A_B9_carbohydrates")
model.addConstr(15*milligrams_vitamin_A + 24*milligrams_vitamin_B3 + 26*milligrams_vitamin_B9 >= 140, name="combined_immune_support_index_A_B3_B9")
model.addConstr(23*milligrams_vitamin_K**2 + 8*milligrams_vitamin_E**2 + 15*milligrams_vitamin_A**2 >= 140, name="combined_immune_support_index_K_E_A")
model.addConstr(15*milligrams_vitamin_A + 24*milligrams_vitamin_B3 + 8*grams_carbohydrates >= 104, name="combined_immune_support_index_A_B3_carbohydrates_2")
model.addConstr(15*milligrams_vitamin_A + 26*milligrams_vitamin_B9 + 8*grams_carbohydrates >= 104, name="combined_immune_support_index_A_B9_carbohydrates_2")
model.addConstr(15*milligrams_vitamin_A**2 + 24*milligrams_vitamin_B3**2 + 26*milligrams_vitamin_B9**2 >= 104, name="combined_immune_support_index_A_B3_B9_2")
model.addConstr(23*milligrams_vitamin_K + 8*milligrams_vitamin_E + 15*milligrams_vitamin_A >= 104, name="combined_immune_support_index_K_E_A_2")

model.addConstr(15*milligrams_vitamin_A**2 + 24*milligrams_vitamin_B3**2 + 8*grams_carbohydrates**2 >= 127, name="combined_immune_support_index_A_B3_carbohydrates_3")
model.addConstr(15*milligrams_vitamin_A + 26*milligrams_vitamin_B9 + 8*grams_carbohydrates >= 127, name="combined_immune_support_index_A_B9_carbohydrates_3")
model.addConstr(15*milligrams_vitamin_A + 24*milligrams_vitamin_B3 + 26*milligrams_vitamin_B9 >= 127, name="combined_immune_support_index_A_B3_B9_3")
model.addConstr(23*milligrams_vitamin_K + 8*milligrams_vitamin_E + 15*milligrams_vitamin_A >= 127, name="combined_immune_support_index_K_E_A_3")

model.addConstr(15*milligrams_vitamin_A + 24*milligrams_vitamin_B3 + 8*grams_carbohydrates >= 81, name="combined_immune_support_index_A_B3_carbohydrates_4")
model.addConstr(15*milligrams_vitamin_A**2 + 26*milligrams_vitamin_B9**2 + 8*grams_carbohydrates**2 >= 81, name="combined_immune_support_index_A_B9_carbohydrates_4")
model.addConstr(15*milligrams_vitamin_A + 24*milligrams_vitamin_B3 + 26*milligrams_vitamin_B9 >= 81, name="combined_immune_support_index_A_B3_B9_4")
model.addConstr(23*milligrams_vitamin_K**2 + 8*milligrams_vitamin_E**2 + 15*milligrams_vitamin_A**2 >= 81, name="combined_immune_support_index_K_E_A_4")
model.addConstr(23*milligrams_vitamin_K + 8*milligrams_vitamin_E + 15*milligrams_vitamin_A + 24*milligrams_vitamin_B3 + 26*milligrams_vitamin_B9 + 8*grams_carbohydrates >= 81, name="combined_immune_support_index_all")

model.addConstr(-2*milligrams_vitamin_B9 + 9*grams_carbohydrates >= 0, name="B9_carbohydrates_constraint")
model.addConstr(-2*milligrams_vitamin_K - milligrams_vitamin_B3 + 2*milligrams_vitamin_B9 >= 0, name="K_B3_B9_constraint")

model.addConstr(8*milligrams_vitamin_E + 24*milligrams_vitamin_B3 <= 305, name="E_B3_constraint")
model.addConstr(8*milligrams_vitamin_E + 8*grams_carbohydrates <= 335, name="E_carbohydrates_constraint")
model.addConstr(23*milligrams_vitamin_K + 15*milligrams_vitamin_A <= 531, name="K_A_constraint")
model.addConstr(15*milligrams_vitamin_A + 24*milligrams_vitamin_B3 <= 208, name="A_B3_constraint")
model.addConstr(23*milligrams_vitamin_K + 8*grams_carbohydrates <= 601, name="K_carbohydrates_constraint")
model.addConstr(15*milligrams_vitamin_A + 24*milligrams_vitamin_B3 + 26*milligrams_vitamin_B9 <= 611, name="A_B3_B9_constraint")
model.addConstr(23*milligrams_vitamin_K + 26*milligrams_vitamin_B9 + 8*grams_carbohydrates <= 595, name="K_B9_carbohydrates_constraint")
model.addConstr(8*milligrams_vitamin_E + 15*milligrams_vitamin_A + 24*milligrams_vitamin_B3 <= 292, name="E_A_B3_constraint")
model.addConstr(15*milligrams_vitamin_A + 26*milligrams_vitamin_B9 + 8*grams_carbohydrates <= 681, name="A_B9_carbohydrates_constraint_2")

# Solve the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("Milligrams of Vitamin K: ", milligrams_vitamin_K.varValue)
    print("Milligrams of Vitamin E: ", milligrams_vitamin_E.varValue)
    print("Milligrams of Vitamin A: ", milligrams_vitamin_A.varValue)
    print("Milligrams of Vitamin B3: ", milligrams_vitamin_B3.varValue)
    print("Milligrams of Vitamin B9: ", milligrams_vitamin_B9.varValue)
    print("Grams of Carbohydrates: ", grams_carbohydrates.varValue)
else:
    print("The model is infeasible")
