
from gurobipy import Model, GRB

# Create a new model
m = Model("Resource Allocation")

# Create variables
security_engineers = m.addVar(vtype=GRB.INTEGER, name="security_engineers")
system_administrators = m.addVar(vtype=GRB.INTEGER, name="system_administrators")
network_administrators = m.addVar(vtype=GRB.INTEGER, name="network_administrators")
pen_testers = m.addVar(vtype=GRB.INTEGER, name="pen_testers")

# Set objective function
m.setObjective(2 * security_engineers + 1 * system_administrators + 7 * network_administrators + 6 * pen_testers, GRB.MINIMIZE)

# Add constraints
m.addConstr(1 * security_engineers + 11 * system_administrators <= 113, "r0") # data integrity impact
m.addConstr(9 * security_engineers + 4 * system_administrators + 1 * network_administrators + 7 * pen_testers <= 99, "r1") # computational load
m.addConstr(14 * security_engineers + 12 * system_administrators + 4 * network_administrators + 4 * pen_testers <= 88, "r2") # network integrity impact

m.addConstr(1 * security_engineers + 11 * system_administrators >= 13, "c1")
m.addConstr(1 * security_engineers + 7 * pen_testers >= 15, "c2")
m.addConstr(5 * network_administrators + 7 * pen_testers >= 15, "c3")
m.addConstr(1 * security_engineers + 11 * system_administrators + 5 * network_administrators + 7 * pen_testers >= 15, "c4")
m.addConstr(1 * network_administrators + 7 * pen_testers >= 15, "c5")
m.addConstr(4 * system_administrators + 1 * network_administrators >= 20, "c6")
m.addConstr(9 * security_engineers + 1 * network_administrators >= 16, "c7")
m.addConstr(9 * security_engineers + 1 * network_administrators + 7 * pen_testers >= 22, "c8")
m.addConstr(9 * security_engineers + 4 * system_administrators + 1 * network_administrators + 7 * pen_testers >= 22, "c9")
m.addConstr(14 * security_engineers + 12 * system_administrators >= 13, "c10")
m.addConstr(14 * security_engineers + 4 * network_administrators >= 11, "c11")
m.addConstr(12 * system_administrators + 4 * pen_testers >= 11, "c12")
m.addConstr(14 * security_engineers + 4 * pen_testers >= 21, "c13")
m.addConstr(14 * security_engineers + 12 * system_administrators + 4 * pen_testers >= 18, "c14")
m.addConstr(12 * system_administrators + 4 * network_administrators + 4 * pen_testers >= 18, "c15")
m.addConstr(14 * security_engineers + 12 * system_administrators + 4 * pen_testers >= 18, "c16")
m.addConstr(12 * system_administrators + 4 * network_administrators + 4 * pen_testers >= 18, "c17")
m.addConstr(14 * security_engineers + 12 * system_administrators + 4 * network_administrators + 4 * pen_testers >= 18, "c18")
m.addConstr(10 * system_administrators - 7 * pen_testers >= 0, "c19")
m.addConstr(5 * network_administrators - 6 * pen_testers >= 0, "c20")
m.addConstr(5 * network_administrators + 7 * pen_testers <= 104, "c21")
m.addConstr(1 * security_engineers + 7 * pen_testers <= 54, "c22")
m.addConstr(1 * security_engineers + 11 * system_administrators + 5 * network_administrators <= 49, "c23")
m.addConstr(11 * system_administrators + 5 * network_administrators + 7 * pen_testers <= 75, "c24")
m.addConstr(9 * security_engineers + 7 * pen_testers <= 34, "c25")
m.addConstr(9 * security_engineers + 4 * system_administrators + 7 * pen_testers <= 36, "c26")
m.addConstr(12 * system_administrators + 4 * pen_testers <= 74, "c27")
m.addConstr(12 * system_administrators + 4 * network_administrators <= 70, "c28")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

