
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
security_engineers = m.addVar(name="security_engineers", vtype=gurobi.GRB.INTEGER)
system_administrators = m.addVar(name="system_administrators", vtype=gurobi.GRB.INTEGER)
network_administrators = m.addVar(name="network_administrators", vtype=gurobi.GRB.INTEGER)
pen_testers = m.addVar(name="pen_testers", vtype=gurobi.GRB.INTEGER)

# Define the objective function
m.setObjective(2 * security_engineers + system_administrators + 7 * network_administrators + 6 * pen_testers, gurobi.GRB.MINIMIZE)

# Add constraints
m.addConstr(security_engineers <= 113, name="r0_security_engineers")
m.addConstr(9 * security_engineers <= 99, name="r1_security_engineers")
m.addConstr(14 * security_engineers <= 88, name="r2_security_engineers")

m.addConstr(11 * system_administrators <= 113, name="r0_system_administrators")
m.addConstr(4 * system_administrators <= 99, name="r1_system_administrators")
m.addConstr(12 * system_administrators <= 88, name="r2_system_administrators")

m.addConstr(5 * network_administrators <= 113, name="r0_network_administrators")
m.addConstr(network_administrators <= 99, name="r1_network_administrators")
m.addConstr(4 * network_administrators <= 88, name="r2_network_administrators")

m.addConstr(7 * pen_testers <= 113, name="r0_pen_testers")
m.addConstr(7 * pen_testers <= 99, name="r1_pen_testers")
m.addConstr(4 * pen_testers <= 88, name="r2_pen_testers")

m.addConstr(security_engineers + 11 * system_administrators >= 13, name="combined_r0_1")
m.addConstr(security_engineers + 7 * pen_testers >= 15, name="combined_r0_2")
m.addConstr(5 * network_administrators + 7 * pen_testers >= 15, name="combined_r0_3")
m.addConstr(security_engineers + 11 * system_administrators + 5 * network_administrators + 7 * pen_testers >= 15, name="combined_r0_4")

m.addConstr(network_administrators + 7 * pen_testers >= 15, name="combined_r1")
m.addConstr(4 * system_administrators + network_administrators >= 20, name="combined_r2")
m.addConstr(9 * security_engineers + network_administrators >= 16, name="combined_r3")
m.addConstr(9 * security_engineers + network_administrators + 7 * pen_testers >= 22, name="combined_r4")
m.addConstr(9 * security_engineers + 4 * system_administrators + network_administrators + 7 * pen_testers >= 22, name="combined_r5")

m.addConstr(14 * security_engineers + 12 * system_administrators >= 13, name="combined_r6")
m.addConstr(14 * security_engineers + 4 * network_administrators >= 11, name="combined_r7")
m.addConstr(12 * system_administrators + 4 * pen_testers >= 11, name="combined_r8")
m.addConstr(14 * security_engineers + 4 * pen_testers >= 21, name="combined_r9")
m.addConstr(14 * security_engineers + 12 * system_administrators + 4 * pen_testers >= 18, name="combined_r10")
m.addConstr(12 * system_administrators + 4 * network_administrators + 4 * pen_testers >= 18, name="combined_r11")

m.addConstr(10 * system_administrators - 7 * pen_testers >= 0, name="combined_r12")
m.addConstr(5 * network_administrators - 6 * pen_testers >= 0, name="combined_r13")

m.addConstr(5 * network_administrators + 7 * pen_testers <= 104, name="combined_r14")
m.addConstr(security_engineers + 7 * pen_testers <= 54, name="combined_r15")
m.addConstr(security_engineers + 11 * system_administrators + 5 * network_administrators <= 49, name="combined_r16")
m.addConstr(11 * system_administrators + 5 * network_administrators + 7 * pen_testers <= 75, name="combined_r17")

m.addConstr(9 * security_engineers + 7 * pen_testers <= 34, name="combined_r18")
m.addConstr(9 * security_engineers + 4 * system_administrators + 7 * pen_testers <= 36, name="combined_r19")

m.addConstr(12 * system_administrators + 4 * pen_testers <= 74, name="combined_r20")
m.addConstr(12 * system_administrators + 4 * network_administrators <= 70, name="combined_r21")

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Security Engineers: ", security_engineers.varValue)
    print("System Administrators: ", system_administrators.varValue)
    print("Network Administrators: ", network_administrators.varValue)
    print("Pen Testers: ", pen_testers.varValue)
else:
    print("The model is infeasible")
