
from gurobipy import Model, GRB

# Define the model
model = Model("Resource Allocation")

# Define decision variables
red_pens = model.addVar(vtype=GRB.INTEGER, name="red_pens")
black_pens = model.addVar(vtype=GRB.INTEGER, name="black_pens")
rubber_bands = model.addVar(vtype=GRB.INTEGER, name="rubber_bands")
printers_3d = model.addVar(vtype=GRB.INTEGER, name="3D_printers")
smoke_detectors = model.addVar(vtype=GRB.INTEGER, name="smoke_detectors")

# Define the objective function
model.setObjective(8 * red_pens + 6 * black_pens + 5 * rubber_bands + 8 * printers_3d + 1 * smoke_detectors, GRB.MAXIMIZE)

# Define constraints
model.addConstr(3 * red_pens + 6 * black_pens + 3 * rubber_bands + 8 * printers_3d + 3 * smoke_detectors <= 292, "Weight Constraint")
model.addConstr(5 * red_pens + 9 * black_pens + 5 * rubber_bands + 3 * printers_3d + 1 * smoke_detectors <= 121, "Employee Satisfaction Constraint")
model.addConstr(3 * red_pens + 2 * black_pens + 5 * rubber_bands + 1 * printers_3d + 5 * smoke_detectors <= 320, "Sustainability Constraint")

model.addConstr(8 * printers_3d + 3 * smoke_detectors >= 20, "Weight_printers_detectors")
model.addConstr(3 * red_pens + 3 * smoke_detectors >= 29, "Weight_redpens_detectors")
model.addConstr(3 * rubber_bands + 8 * printers_3d >= 54, "Weight_bands_printers")
model.addConstr(6 * black_pens + 3 * smoke_detectors >= 50, "Weight_blackpens_detectors")
model.addConstr(6 * black_pens + 8 * printers_3d + 3 * smoke_detectors >= 32, "Weight_blackpens_printers_detectors")
model.addConstr(3 * red_pens + 8 * printers_3d + 3 * smoke_detectors >= 32, "Weight_redpens_printers_detectors")
model.addConstr(6 * black_pens + 3 * rubber_bands + 3 * smoke_detectors >= 32, "Weight_blackpens_bands_detectors")
model.addConstr(6 * black_pens + 8 * printers_3d + 3 * smoke_detectors >= 30, "Weight_blackpens_printers_detectors_2")
model.addConstr(3 * red_pens + 8 * printers_3d + 3 * smoke_detectors >= 30, "Weight_redpens_printers_detectors_2")
model.addConstr(6 * black_pens + 3 * rubber_bands + 3 * smoke_detectors >= 30, "Weight_blackpens_bands_detectors_2")
model.addConstr(6 * black_pens + 8 * printers_3d + 3 * smoke_detectors >= 35, "Weight_blackpens_printers_detectors_3")
model.addConstr(3 * red_pens + 8 * printers_3d + 3 * smoke_detectors >= 35, "Weight_redpens_printers_detectors_3")
model.addConstr(6 * black_pens + 3 * rubber_bands + 3 * smoke_detectors >= 35, "Weight_blackpens_bands_detectors_3")


# ... (Add all other constraints similarly)

# Optimize the model
model.optimize()

# Print the solution
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Red Pens: {red_pens.x}")
    print(f"Black Pens: {black_pens.x}")
    print(f"Rubber Bands: {rubber_bands.x}")
    print(f"3D Printers: {printers_3d.x}")
    print(f"Smoke Detectors: {smoke_detectors.x}")
    print(f"Objective Value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

